#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_reservation_station_Reservation_station_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_reservation_station_Reservation_station_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include <vector>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Statistics.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif

using namespace std;

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {

  class Treservation_station_entry_t
  {
  public    : Tcontext_t         _context_id  ;
  public    : Tpacket_t          _packet_id   ;
  public    : Toperation_t       _operation   ;
  public    : Ttype_t            _type        ;
  public    : Tcontrol_t         _has_immediat;
  public    : Tgeneral_data_t    _immediat    ;
//public    : Tcontrol_t         _read_ra     ;
  public    : Tgeneral_address_t _num_reg_ra  ;
  public    : Tcontrol_t         _data_ra_val ;
  public    : Tgeneral_data_t    _data_ra     ;
//public    : Tcontrol_t         _read_rb     ;
  public    : Tgeneral_address_t _num_reg_rb  ;
  public    : Tcontrol_t         _data_rb_val ;
  public    : Tgeneral_data_t    _data_rb     ;
//public    : Tcontrol_t         _read_rc     ;
  public    : Tspecial_address_t _num_reg_rc  ;
  public    : Tcontrol_t         _data_rc_val ;
  public    : Tspecial_data_t    _data_rc     ;
  public    : Tcontrol_t         _write_rd    ;
  public    : Tgeneral_address_t _num_reg_rd  ;
  public    : Tcontrol_t         _write_re    ;
  public    : Tspecial_address_t _num_reg_re  ;

    friend ostream& operator<< (ostream& output_stream,
				morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Treservation_station_entry_t & x)
    {
      output_stream << " * _context_id  : " << toString(x._context_id  ) << endl
		    << " * _packet_id   : " << toString(x._packet_id   ) << endl
		    << " * _operation   : " << toString(x._operation   ) << endl
		    << " * _type        : " << toString(x._type        ) << endl
		    << " * _has_immediat: " << toString(x._has_immediat) << endl
		    << " * _immediat    : " << toString(x._immediat    ) << endl
// 		    << " * _read_ra     : " << toString(x._read_ra     ) << endl
		    << " * _num_reg_ra  : " << toString(x._num_reg_ra  ) << endl
		    << " * _data_ra_val : " << toString(x._data_ra_val ) << endl
		    << " * _data_ra     : " << toString(x._data_ra     ) << endl
// 		    << " * _read_rb     : " << toString(x._read_rb     ) << endl
		    << " * _num_reg_rb  : " << toString(x._num_reg_rb  ) << endl
		    << " * _data_rb_val : " << toString(x._data_rb_val ) << endl
		    << " * _data_rb     : " << toString(x._data_rb     ) << endl
// 		    << " * _read_rc     : " << toString(x._read_rc     ) << endl
		    << " * _num_reg_rc  : " << toString(x._num_reg_rc  ) << endl
		    << " * _data_rc_val : " << toString(x._data_rc_val ) << endl
		    << " * _data_rc     : " << toString(x._data_rc     ) << endl
		    << " * _write_rd    : " << toString(x._write_rd    ) << endl
		    << " * _num_reg_rd  : " << toString(x._num_reg_rd  ) << endl
		    << " * _write_re    : " << toString(x._write_re    ) << endl
		    << " * _num_reg_re  : " << toString(x._num_reg_re  ) << endl;

      return output_stream;
    }

  };

  class Reservation_station 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string       _name;

  protected : const Parameters * _param;
//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics * _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[Interface "reservation_station_in" ]~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_VAL         ;
  public    : SC_OUT(Tcontrol_t        )    * out_RESERVATION_STATION_IN_ACK         ;
  public    : SC_IN (Tcontext_t        )    *  in_RESERVATION_STATION_IN_CONTEXT_ID  ;
  public    : SC_IN (Tpacket_t         )    *  in_RESERVATION_STATION_IN_PACKET_ID   ;
  public    : SC_IN (Toperation_t      )    *  in_RESERVATION_STATION_IN_OPERATION   ;
  public    : SC_IN (Ttype_t           )    *  in_RESERVATION_STATION_IN_TYPE        ;
  public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_HAS_IMMEDIAT;
  public    : SC_IN (Tgeneral_data_t   )    *  in_RESERVATION_STATION_IN_IMMEDIAT    ;
//public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_READ_RA     ;
  public    : SC_IN (Tgeneral_address_t)    *  in_RESERVATION_STATION_IN_NUM_REG_RA  ;
  public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_DATA_RA_VAL ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_RESERVATION_STATION_IN_DATA_RA     ;
//public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_READ_RB     ;
  public    : SC_IN (Tgeneral_address_t)    *  in_RESERVATION_STATION_IN_NUM_REG_RB  ;
  public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_DATA_RB_VAL ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_RESERVATION_STATION_IN_DATA_RB     ;
//public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_READ_RC     ;
  public    : SC_IN (Tspecial_address_t)    *  in_RESERVATION_STATION_IN_NUM_REG_RC  ;
  public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_DATA_RC_VAL ;
  public    : SC_IN (Tspecial_data_t   )    *  in_RESERVATION_STATION_IN_DATA_RC     ;
  public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_WRITE_RD    ;
  public    : SC_IN (Tgeneral_address_t)    *  in_RESERVATION_STATION_IN_NUM_REG_RD  ;
  public    : SC_IN (Tcontrol_t        )    *  in_RESERVATION_STATION_IN_WRITE_RE    ;
  public    : SC_IN (Tspecial_address_t)    *  in_RESERVATION_STATION_IN_NUM_REG_RE  ;

    // ~~~~~[Interface "reservation_station_out" ]~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_RESERVATION_STATION_OUT_VAL         ;
  public    : SC_IN (Tcontrol_t        )   **  in_RESERVATION_STATION_OUT_ACK         ;
  public    : SC_OUT(Tcontext_t        )   ** out_RESERVATION_STATION_OUT_CONTEXT_ID  ;
  public    : SC_OUT(Tpacket_t         )   ** out_RESERVATION_STATION_OUT_PACKET_ID   ;
  public    : SC_OUT(Toperation_t      )   ** out_RESERVATION_STATION_OUT_OPERATION   ;
  public    : SC_OUT(Ttype_t           )   ** out_RESERVATION_STATION_OUT_TYPE        ;
  public    : SC_OUT(Tcontrol_t        )   ** out_RESERVATION_STATION_OUT_HAS_IMMEDIAT;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_RESERVATION_STATION_OUT_IMMEDIAT    ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_RESERVATION_STATION_OUT_DATA_RA     ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_RESERVATION_STATION_OUT_DATA_RB     ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_RESERVATION_STATION_OUT_DATA_RC     ;
  public    : SC_OUT(Tcontrol_t        )   ** out_RESERVATION_STATION_OUT_WRITE_RD    ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_RESERVATION_STATION_OUT_NUM_REG_RD  ;
  public    : SC_OUT(Tcontrol_t        )   ** out_RESERVATION_STATION_OUT_WRITE_RE    ;
  public    : SC_OUT(Tspecial_address_t)   ** out_RESERVATION_STATION_OUT_NUM_REG_RE  ;

    // ~~~~~[Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_VAL       ; // val and ack
  public    : SC_IN (Tcontext_t        )   **  in_GPR_WRITE_CONTEXT_ID;
  public    : SC_IN (Tgeneral_address_t)   **  in_GPR_WRITE_NUM_REG   ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_WRITE_DATA      ;

    // ~~~~~[Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_VAL       ; // val and ack
  public    : SC_IN (Tcontext_t        )   **  in_SPR_WRITE_CONTEXT_ID;
  public    : SC_IN (Tspecial_address_t)   **  in_SPR_WRITE_NUM_REG   ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_WRITE_DATA      ;

    // ~~~~~[Interface "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontext_t        )   **  in_BYPASS_WRITE_CONTEXT_ID ;
  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_WRITE_GPR_VAL    ;
  public    : SC_IN (Tgeneral_address_t)   **  in_BYPASS_WRITE_GPR_NUM_REG; // RD
  public    : SC_IN (Tgeneral_data_t   )   **  in_BYPASS_WRITE_GPR_DATA   ;
  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_WRITE_SPR_VAL    ;
  public    : SC_IN (Tspecial_address_t)   **  in_BYPASS_WRITE_SPR_NUM_REG; // RE
  public    : SC_IN (Tspecial_data_t   )   **  in_BYPASS_WRITE_SPR_DATA   ;

    // ~~~~~[Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_MEMORY_VAL       ;
  public    : SC_IN (Tcontext_t        )   **  in_BYPASS_MEMORY_CONTEXT_ID;
  public    : SC_IN (Tgeneral_address_t)   **  in_BYPASS_MEMORY_NUM_REG   ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_BYPASS_MEMORY_DATA      ;


    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  protected : vector<uint32_t>              *  _queue_control;
  protected : uint32_t                         _queue_nb_elt;
  protected : Treservation_station_entry_t  *  _queue;

  protected : Tcontrol_t                       internal_RESERVATION_STATION_IN_ACK;
  protected : Tcontrol_t                    *  internal_RESERVATION_STATION_OUT_VAL;
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Reservation_station);
#endif
  public  :          Reservation_station              (
#ifdef SYSTEMC
					      sc_module_name                                name,
#else					       
					      string                                        name,
#endif					       
#ifdef STATISTICS
					      morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
					      Parameters                                  * param );
  public  :          ~Reservation_station             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
  public  : void     transition                (void);
  public  : void     genMoore                  (void);
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
