/*
 * $Id$
 *
 * [Description ]
 * 
 * Test
 */

#include "Behavioural/@DIRECTORY/SelfTest/include/test.h"
#include "Common/include/Test.h"

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#define LABEL(str)                                                                       \
{                                                                                        \
  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} " << str << endl; \
} while(0)

static uint32_t cycle = 0;

#define SC_START(cycle_offset)                                          \
do                                                                      \
{                                                                       \
/*cout << "SC_START (begin)" << endl;*/                                 \
                                                                        \
  uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time()); \
  if (cycle_current != cycle)                                           \
    {                                                                   \
      cycle = cycle_current;                                            \
      cout << "##########[ cycle "<< cycle << " ]" << endl;             \
    }                                                                   \
                                                                        \
  if (cycle_current > CYCLE_MAX)                                        \
    {                                                                   \
      TEST_KO("Maximal cycles Reached");                                \
    }                                                                   \
  sc_start(cycle_offset);                                               \
/*cout << "SC_START (end  )" << endl;*/                                 \
} while(0)

void test (string name,
	   morpheo::behavioural::@NAMESPACE_USE::Parameters * _param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  @COMPONENT * _@COMPONENT = new @COMPONENT (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  sc_clock                               * in_CLOCK;
  sc_signal<Tcontrol_t>                  * in_NRESET;

  string rename;

  in_CLOCK                                = new sc_clock ("clock", 1.0, 0.5);
  in_NRESET                               = new sc_signal<Tcontrol_t> ("NRESET");
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _@COMPONENT" << endl;
  
  (*(_@COMPONENT->in_CLOCK))        (*(in_CLOCK));
  (*(_@COMPONENT->in_NRESET))       (*(in_NRESET));


  cout << "<" << name << "> Start Simulation ............" << endl;
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration "+toString(iteration));

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;
  cout << "<" << name << "> ............ Stop Simulation" << endl;

  delete in_CLOCK;
  delete in_NRESET;
#endif

  delete _@COMPONENT;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
