#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Reservation_station.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {


#undef  FUNCTION
#define FUNCTION "Reservation_station::genMoore"
  void Reservation_station::genMoore (void)
  {
    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");

    // ~~~~~[Interface "reservation_station_in" ]~~~~~~~~~~~~~~~~~~~~~~~~
    
    // accept a new instructions when reservation_station is not full
    internal_RESERVATION_STATION_IN_ACK = _queue_nb_elt < _param->_size_queue;
    
    PORT_WRITE(out_RESERVATION_STATION_IN_ACK, internal_RESERVATION_STATION_IN_ACK);

    // ~~~~~[Interface "reservation_station_out" ]~~~~~~~~~~~~~~~~~~~~~~~

    for (uint32_t i=0; i<_param->_size_queue; i++)
      {
	bool     val   = i <_queue_nb_elt;
	uint32_t index = (*_queue_control)[i];
	
	if (val == true)
	  {
	    // valid if all data is present
 	    val = (_queue[index]._data_ra_val and 
		   _queue[index]._data_rb_val and 
		   _queue[index]._data_rc_val);

	    PORT_WRITE(out_RESERVATION_STATION_OUT_CONTEXT_ID  [index],_queue[index]._context_id);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_PACKET_ID   [index],_queue[index]._packet_id);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_OPERATION   [index],_queue[index]._operation);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_TYPE        [index],_queue[index]._type);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_HAS_IMMEDIAT[index],_queue[index]._has_immediat);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_IMMEDIAT    [index],_queue[index]._immediat);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_DATA_RA     [index],_queue[index]._data_ra);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_DATA_RB     [index],_queue[index]._data_rb);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_DATA_RC     [index],_queue[index]._data_rc);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_WRITE_RD    [index],_queue[index]._write_rd);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_NUM_REG_RD  [index],_queue[index]._num_reg_rd);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_WRITE_RE    [index],_queue[index]._write_re);
	    PORT_WRITE(out_RESERVATION_STATION_OUT_NUM_REG_RE  [index],_queue[index]._num_reg_re);
	  }
	
	internal_RESERVATION_STATION_OUT_VAL [index] = val;
	PORT_WRITE(out_RESERVATION_STATION_OUT_VAL [index], internal_RESERVATION_STATION_OUT_VAL [index]);
      }

    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
