/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


#ifdef SYSTEMC
  RegisterFile_Multi_Banked::RegisterFile_Multi_Banked (sc_module_name name,
#else
  RegisterFile_Multi_Banked::RegisterFile_Multi_Banked (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
			      morpheo::behavioural::generic::registerfile::registerfile_multi_banked::Parameters * param ):
			      _name              (name)
			      ,_param            (param)
// #ifdef STATISTICS
// 			      ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"RegisterFile_Multi_Banked","Begin");

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile_Multi_Banked,"RegisterFile_Multi_Banked","Allocation");

    allocation ();
#endif

#ifdef STATISTICS
    log_printf(INFO,RegisterFile_Multi_Banked,"RegisterFile_Multi_Banked","Allocation of statistics");

    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(INFO,RegisterFile_Multi_Banked,"RegisterFile_Multi_Banked","Generate the vhdl");

    vhdl();
#endif

#ifdef SYSTEMC
    // Function pointer
    if (_param->_crossbar == FULL_CROSSBAR)                             
      {
	function_transition     = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   full_crossbar_transition;
	function_genMealy_read  = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   full_crossbar_genMealy_read;
	function_genMealy_write = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   full_crossbar_genMealy_write;
      }
    else
      {
	function_transition     = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   partial_crossbar_transition;
	function_genMealy_read  = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   partial_crossbar_genMealy_read;
	function_genMealy_write = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   partial_crossbar_genMealy_write;
      }

    log_printf(INFO,RegisterFile_Multi_Banked,"RegisterFile_Multi_Banked","Method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

    log_printf(INFO,RegisterFile_Multi_Banked,"RegisterFile_Multi_Banked","Method - genMealy_write");

    SC_METHOD (genMealy_read);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);
    for (uint32_t i=0; i<_param->_nb_port_read; i++)
      sensitive << *( in_READ_VAL     [i])
		<< *( in_READ_ADDRESS [i]);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param->_nb_port_read; i++)
      {
	(*(out_READ_ACK  [i])) (*( in_READ_VAL     [i]));
	(*(out_READ_ACK  [i])) (*( in_READ_ADDRESS [i]));
	(*(out_READ_DATA [i])) (*( in_READ_VAL     [i]));
	(*(out_READ_DATA [i])) (*( in_READ_ADDRESS [i]));
      }
//     for (uint32_t i=0; i<_param->_nb_port_read_write; i++)
//       {  
// 	(*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_VAL     [i]));
// 	(*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_RW      [i]));
// 	(*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_ADDRESS [i]));
//       }
#endif    

    SC_METHOD (genMealy_write);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);
    for (uint32_t i=0; i<_param->_nb_port_write; i++)
      sensitive << *( in_WRITE_VAL     [i])
		<< *( in_WRITE_ADDRESS [i])
		<< *( in_WRITE_DATA    [i]);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param->_nb_port_write; i++)
      {
	(*(out_WRITE_ACK  [i])) (*( in_WRITE_VAL     [i]));
	(*(out_WRITE_ACK  [i])) (*( in_WRITE_ADDRESS [i]));
	(*(out_WRITE_ACK  [i])) (*( in_WRITE_DATA    [i]));
      }
#endif    

#endif
    log_printf(FUNC,RegisterFile_Multi_Banked,"RegisterFile_Multi_Banked","End");
  };
  
  RegisterFile_Multi_Banked::~RegisterFile_Multi_Banked (void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"~RegisterFile_Multi_Banked","Begin");

#ifdef STATISTICS
    log_printf(INFO,RegisterFile_Multi_Banked,"~RegisterFile_Multi_Banked","Generate Statistics file");

    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile_Multi_Banked,"~RegisterFile_Multi_Banked","Deallocation");

    deallocation ();
#endif

    log_printf(FUNC,RegisterFile_Multi_Banked,"~RegisterFile_Multi_Banked","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
