#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  void RegisterFile_Multi_Banked::full_crossbar_genMealy_write (void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"full_crossbar_genMealy_write","Begin");

    bool write_port_use [_param->_nb_bank][_param->_nb_port_write_by_bank];

    for (uint32_t i=0; i<_param->_nb_bank; i++)
      for (uint32_t j=0; j<_param->_nb_port_write_by_bank; j++)
	write_port_use [i][j]=false;

    for (uint32_t i=0; i<_param->_nb_port_write; i++)
      {
	bool val = PORT_READ(in_WRITE_VAL    [i]);
	bool ack = false;

	log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_write","write[%d] : %d",i,val);

	if (val == true)
	  {
	    val                = false;
	    // Compute the adress of the bank
	    Taddress_t address = PORT_READ(in_WRITE_ADDRESS[i]);
	    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_write"," * address   : %d",address);
	    Taddress_t bank    = address_bank    (address);
	    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_write"," * bank      : %d",bank   );

	    // Search loop
	    for (uint32_t j=0; j<_param->_nb_port_write_by_bank; j++)
	      {
		// find a unbusy port on this bank
		if (write_port_use[bank][j] == false)
		  {
		    // find !!!
		    write_port_use[bank][j] = true;
		    val                     = true;  
		    ack                     = true;
		    
		    Taddress_t num_reg = address_num_reg (address);

		    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_write"," * num_reg   : %d",num_reg);
		    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_write"," * bank_port : %d",j      );
		    		    
		    internal_WRITE_NUM_REG [i] = num_reg;
		    break;
		  }
	      }

	    internal_WRITE_BANK [i] = bank;
	  }

	internal_WRITE_VAL [i] = val;

	// Write output
	PORT_WRITE(out_WRITE_ACK [i], ack);
      }

    log_printf(FUNC,RegisterFile_Multi_Banked,"full_crossbar_genMealy_write","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
