set size 1.0, 1.0
set terminal postscript eps enhanced color

set out "../Schema_eps/synthese_FPGA-registerfile.eps"

unset label
unset log

set data style boxes
set boxwidth 10
set style fill solid 1.000000 border -1
   
set grid
set xlabel "Architecture"
set ylabel "Nombre LUTs"
set yrange [1:100000]
unset logscale; set logscale y 
set xtics rotate by -25 ('R:1  W:1'    0 , \
			 'R:2  W:1'   60 , \
			 'R:4  W:1'  120 , \
			 'R:8  W:1'  180 , \
			 'R:1  W:2'  240 , \
			 'R:1  W:4'  300 , \
			 'R:1  W:8'  360 )

plot "synthese_FPGA-registerfile_monolithic.dat" title "monolithic",\
     "synthese_FPGA-registerfile_1_bank.dat"     title "1 banc"    ,\
     "synthese_FPGA-registerfile_2_bank.dat"     title "2 bancs"   ,\
     "synthese_FPGA-registerfile_4_bank.dat"     title "4 bancs"   ,\
     "synthese_FPGA-registerfile_8_bank.dat"     title "8 bancs"

     
