/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Select_Priority_Fixed/include/Select_Priority_Fixed.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace select {
namespace select_priority_fixed {


  Select_Priority_Fixed::Select_Priority_Fixed 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics           *  param_statistics,
#endif
   morpheo::behavioural::generic::select::select_priority_fixed::Parameters * param,
   morpheo::behavioural::Tusage_t usage ):
    _name              (name),
    _param            (param),
    _usage            (usage)
// #ifdef STATISTICS
// 			      ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,Select_Priority_Fixed,"Select_Priority_Fixed","Begin");

    log_printf(INFO,Select_Priority_Fixed,"Select_Priority_Fixed","Allocation");
    allocation ();

#ifdef STATISTICS
    log_printf(INFO,Select_Priority_Fixed,"Select_Priority_Fixed","Allocation of statistics");

    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(INFO,Select_Priority_Fixed,"Select_Priority_Fixed","Generate the vhdl");

    vhdl();
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
#  if defined(STATISTICS) or defined(VHDL_TESTBENCH)
	log_printf(INFO,Select_Priority_Fixed,"Select_Priority_Fixed","Method - transition");
	
	SC_METHOD (transition);
	dont_initialize ();
	sensitive_pos << *(in_CLOCK);
#  endif
	
	log_printf(INFO,Select_Priority_Fixed,"Select_Priority_Fixed","Method - genMealy_entity");
	
	SC_METHOD (genMealy_entity);
	dont_initialize ();
	//sensitive_pos << *(in_CLOCK);
	for (uint32_t i=0; i<_param->_nb_entity; i++)
	  sensitive << *(in_VAL [i]);
	
#  ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	
	for (uint32_t i=0; i<_param->_nb_entity; i++)
	  {
	    if (_param->_encoding_one_hot)
	      (*(out_ACK    [i])) (*(in_VAL [i]));
	    if (_param->_encoding_compact)
	      {
		(*(out_ENTITY    )) (*(in_VAL [i]));
		(*(out_ENTITY_ACK)) (*(in_VAL [i]));
	      }
	  }
	
#  endif
      }
#endif
    log_printf(FUNC,Select_Priority_Fixed,"Select_Priority_Fixed","End");
  };
  
  Select_Priority_Fixed::~Select_Priority_Fixed (void)
  {
    log_printf(FUNC,Select_Priority_Fixed,"~Select_Priority_Fixed","Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	log_printf(INFO,Select_Priority_Fixed,"~Select_Priority_Fixed","Generate Statistics file");
	
	_stat->generate_file(statistics(0));
	delete _stat;
      }
#endif

#ifdef SYSTEMC
    log_printf(INFO,Select_Priority_Fixed,"~Select_Priority_Fixed","Deallocation");

    deallocation ();
#endif

    log_printf(FUNC,Select_Priority_Fixed,"~Select_Priority_Fixed","End");
  };

}; // end namespace select_priority_fixed
}; // end namespace select
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
