#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {

  void RegisterFile::allocation (void)
  {
    in_CLOCK  = new SC_CLOCK           ("in_CLOCK");
    in_NRESET = new SC_IN (Tcontrol_t) ("in_NRESET");

    // ----- Interface Read
     in_READ_VAL         = new SC_IN (Tcontrol_t) * [_param._nb_port_read];
    out_READ_ACK         = new SC_OUT(Tcontrol_t) * [_param._nb_port_read];
     in_READ_ADDRESS     = new SC_IN (Taddress_t) * [_param._nb_port_read];
    out_READ_DATA        = new SC_OUT(Tdata_t   ) * [_param._nb_port_read];

    for (uint32_t i=0; i<_param._nb_port_read; i++)
      {
	string rename;

	rename = "in_READ_VAL["     + toString(i) + "]";
	in_READ_VAL     [i]  = new SC_IN (Tcontrol_t) (rename.c_str());

	rename = "out_READ_ACK["     + toString(i) + "]";
	out_READ_ACK    [i]  = new SC_OUT(Tcontrol_t) (rename.c_str());

	rename = "in_READ_ADDRESS[" + toString(i) + "]";
	in_READ_ADDRESS [i]  = new SC_IN (Taddress_t) (rename.c_str());

	rename = "out_READ_DATA["    + toString(i) + "]";
	out_READ_DATA   [i]  = new SC_OUT(Tdata_t)    (rename.c_str());
      }

    // ----- Interface Write
     in_WRITE_VAL        = new SC_IN (Tcontrol_t) * [_param._nb_port_write];
    out_WRITE_ACK        = new SC_OUT(Tcontrol_t) * [_param._nb_port_write];
     in_WRITE_ADDRESS    = new SC_IN (Taddress_t) * [_param._nb_port_write];
     in_WRITE_DATA       = new SC_IN (Tdata_t   ) * [_param._nb_port_write];
    
    for (uint32_t i=0; i<_param._nb_port_write; i++)
      {
	string rename;

	rename = "in_WRITE_VAL["  + toString(i) + "]";
	in_WRITE_VAL     [i]  = new SC_IN (Tcontrol_t) (rename.c_str());

	rename = "out_WRITE_VAL["  + toString(i) + "]";
	out_WRITE_ACK    [i]  = new SC_OUT(Tcontrol_t) (rename.c_str());

	rename = "in_WRITE_ADDRESS[" + toString(i) + "]";
	in_WRITE_ADDRESS [i]  = new SC_IN (Taddress_t) (rename.c_str());

	rename = "in_WRITE_DATA["    + toString(i) + "]";
	in_WRITE_DATA    [i]  = new SC_IN (Tdata_t)    (rename.c_str());
      }

    // ----- Register
    reg_DATA = new SC_REGISTER (Tdata_t) * [_param._nb_word];
    
    for (uint32_t i=0; i<_param._nb_word; i++)
      {
	string rename = "reg_DATA["  + toString(i) + "]";
	reg_DATA [i]  = new SC_REGISTER (Tdata_t) (rename.c_str());
      }    
  };

}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
