#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Register_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_unit_Glue::genMealy_spr_write"
  void Register_unit_Glue::genMealy_spr_write (void)
  {
    log_printf(FUNC,Register_unit_Glue,FUNCTION,"Begin");

    for (uint32_t j=0; j<_param->_nb_spr_write; j++)
      {
	Tcontext_t ooo_engine_id;
	if (_param->_have_port_ooo_engine_id == true)
	  ooo_engine_id = PORT_READ(in_SPR_WRITE_OOO_ENGINE_ID        [j]);
	else
	  ooo_engine_id = 0;

	Tcontrol_t registerfile_ack = PORT_READ(in_SPR_WRITE_REGISTERFILE_ACK [ooo_engine_id][j]);
	Tcontrol_t status_ack       = PORT_READ(in_SPR_WRITE_STATUS_ACK       [ooo_engine_id][j]);

	// multiplexor
	PORT_WRITE(out_SPR_WRITE_ACK      [j],registerfile_ack and status_ack);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    Tcontrol_t registerfile_val;
	    Tcontrol_t status_val;
	    if (i == ooo_engine_id)
	      {
		registerfile_val = PORT_READ(in_SPR_WRITE_VAL [j]);
		status_val       = PORT_READ(in_SPR_WRITE_VAL [j]);
	      }
	    else
	      {
		registerfile_val = 0;
		status_val       = 0;
	      }
	    
	    PORT_WRITE(out_SPR_WRITE_REGISTERFILE_VAL  [i][j], registerfile_val and status_ack      );
	    PORT_WRITE(out_SPR_WRITE_STATUS_VAL        [i][j], status_val       and registerfile_ack);
	  }
      }

    log_printf(FUNC,Register_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
