#ifndef morpheo_behavioural_generic_registerfile_registerfile_multi_banked_Parameters_h
#define morpheo_behavioural_generic_registerfile_registerfile_multi_banked_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Common/include/FromString.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/Types.h"
#include <math.h>

namespace morpheo {
  typedef enum {PARTIAL_CROSSBAR,
		FULL_CROSSBAR   } Tcrossbar_t;

  template<> inline Tcrossbar_t fromString<Tcrossbar_t> (const std::string& x)
  {
    if ( (x.compare("0")                == 0) or
	 (x.compare("PARTIAL_CROSSBAR") == 0))
      return PARTIAL_CROSSBAR;
    if ( (x.compare("1")                == 0) or
	 (x.compare("FULL_CROSSBAR"   ) == 0))
      return FULL_CROSSBAR;

    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  };
  
  template<> inline std::string toString<Tcrossbar_t>   (const Tcrossbar_t& x)
  {
    ostringstream out;

    if (x == PARTIAL_CROSSBAR)
      out << "PARTIAL_CROSSBAR";
    if (x == FULL_CROSSBAR)
      out << "FULL_CROSSBAR";

    return out.str();
  };

namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t    _nb_port_read         ; // Global read  port
  public : const uint32_t    _nb_port_write        ; // Global write port
  public : const uint32_t    _nb_word              ;
  public : const uint32_t    _size_word            ;
  public : const uint32_t    _nb_bank              ; // Number of bank (All bank is identical)
  public : const uint32_t    _nb_port_read_by_bank ; // Local  read  port
  public : const uint32_t    _nb_port_write_by_bank; // Local  write port
  public : const Tcrossbar_t _crossbar             ;

  public : const uint32_t    _size_address         ;
  public : const uint32_t    _size_address_by_bank ;

  public : const uint32_t    _bank_shift           ;
  public : const Taddress_t  _bank_mask            ;
  public : const uint32_t    _num_reg_shift        ;
  public : const Taddress_t  _num_reg_mask         ;

  public : const uint32_t    _nb_word_by_bank      ;

  public : const bool        _have_port_address     ;
  public : const bool        _have_bank_port_address;

    // A lot of table to the partial crossbar
  public :       uint32_t  * _link_port_read_to_bank_read  ;
//public :       uint32_t  * _link_port_read_to_num_bank   ;
  public :       uint32_t  * _link_port_write_to_bank_write;
//public :       uint32_t  * _link_port_write_to_num_bank  ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t    nb_port_read         ,
			uint32_t    nb_port_write        ,
			uint32_t    nb_word              ,
			uint32_t    size_word            ,
			uint32_t    nb_bank              ,
			uint32_t    nb_port_read_by_bank ,
			uint32_t    nb_port_write_by_bank,
			Tcrossbar_t crossbar             );
  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : string msg_error (void);

  public :        string   print      (uint32_t depth);
  public : friend ostream& operator<< (ostream& output_stream,
				       morpheo::behavioural::generic::registerfile::registerfile_multi_banked::Parameters & x);
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
