/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Signal.h"


namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Signal::test_map"
  bool Signal::test_map (bool top_level)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    log_printf(INFO,Behavioural,FUNCTION, "     * Signal \"%s\"",_name.c_str());

    bool _return = false;

    if (top_level == true)
      {
	_return = _is_map_as_dest; 
	      
	switch (_direction)
	  {
	  case morpheo::behavioural::IN       : 
	    {
	      if (_return == false)
		cerr << "Signal \"" << _name << "\" is not mapped with an outpout port or a component." << endl;
	      break;
	    }
	  case morpheo::behavioural::OUT      : 
	    {
	      if (_return == false)
		cerr << "Signal \"" << _name << "\" is not mapped with an input port or a component." << endl;
	      break;
	    }
	    //case morpheo::behavioural::INTERNAL : return "internal" ; break;
	    //case morpheo::behavioural::INOUT    : return "inout"    ; break;
	  default    : break;
	  }
      }
    else
      {
	_return = _is_map_as_src and _is_map_as_dest;

	if (_return == false)
	  {
	    if (_is_map_as_src  == false)
	      cerr << "Signal \"" << _name << "\" is not mapped as source" << endl;
	    if (_is_map_as_dest == false)
	      cerr << "Signal \"" << _name << "\" is not mapped as destination" << endl;
	  }
      }
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
    
    return _return;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
