#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {
  void RegisterFile_Monolithic::transition (void)
  {
    log_printf(FUNC,RegisterFile,"transition","Begin");
#ifdef STATISTICS
    _stat_nb_write = 0;
#endif    

    for (uint32_t i=0; i<_param->_nb_port_write; i++)
      {
	// Have a write?
 	if ( PORT_READ(in_WRITE_VAL[i]) == true)
 	  {
#ifdef STATISTICS
	    _stat_nb_write ++;
#endif    

	    Taddress_t address;
	    if (_param->_have_port_address)
	      address = PORT_READ(in_WRITE_ADDRESS[i]);
	    else
	      address = 0;

	    Tdata_t    data    = PORT_READ(in_WRITE_DATA   [i]);
	    
	    log_printf(TRACE,RegisterFile,"transition","[%d] <- %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));

	    // Write in registerFile
	    REGISTER_WRITE(reg_DATA[address],data);
 	  }
      }
    for (uint32_t i=0; i<_param->_nb_port_read_write; i++)
      {
	// Have a read_write?
 	if ( (PORT_READ(in_READ_WRITE_VAL[i]) == true) and
	     (PORT_READ(in_READ_WRITE_RW [i]) == RW_WRITE))
 	  {
#ifdef STATISTICS
	    _stat_nb_write ++;
#endif    

	    Taddress_t address;
	    if (_param->_have_port_address)
	      address = PORT_READ(in_READ_WRITE_ADDRESS[i]);
	    else
	      address = 0;
	    Tdata_t    data    = PORT_READ(in_READ_WRITE_WDATA  [i]);
	    
	    log_printf(TRACE,RegisterFile,"transition","[%d] <- %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));

	    // Write in registerFile
	    REGISTER_WRITE(reg_DATA[address],data);
 	  }
      }

#ifdef STATISTICS
    _stat->add(_stat_nb_read,_stat_nb_write);
#endif    

#ifdef VHDL_TESTBENCH
    vhdl_testbench_transition ();
#endif
    log_printf(FUNC,RegisterFile,"transition","End");
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
