/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Component.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Component::test_map"
  bool Component::test_map (void)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    string name = _entity->get_name();
    bool test_ok = true;
    if (_list_component->empty () == true)
      log_printf(NONE,Behavioural,FUNCTION, "Component \"%s\" is a behavioural description",name.c_str());
    else
      {
	log_printf(NONE,Behavioural,FUNCTION, "Component \"%s\" is a structural description",name.c_str());

	log_printf(INFO,Behavioural,FUNCTION, "Test port I/O");
	
	test_ok &= _entity->test_map(true);

	log_printf(INFO,Behavioural,FUNCTION, "Test all internal component");
	
	for (list<Tcomponent_t *>::iterator i= _list_component->begin();
	     i != _list_component->end();
	     ++i)
	  test_ok &= (*i)->_entity->test_map(false);
      }
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
    
    if (test_ok == false)
      throw (ErrorMorpheo ("<Component::test_map> A lot of port is not connected."));

    return test_ok;
  };


}; // end namespace behavioural          
}; // end namespace morpheo              
