#ifndef DEBUG_H
#define DEBUG_H

#include "Behavioural/include/Debug_component.h"
#include <stdio.h>
#include <string.h>
#include <iostream>
#include <sstream>
#include <string>
using namespace std;

// Debug's Level :
//  * None    : print elementary information
//  * Info    : print basic information
//  * Trace   : trace internal variable
//  * Func    : trace call and return function
//  * All     : print all information

enum _debug_verbosity 
  {
    DEBUG_NONE ,
    DEBUG_INFO ,
    DEBUG_TRACE,
    DEBUG_FUNC ,
    DEBUG_ALL
  };

#ifdef DEBUG
//Debug
#  define log_printf(level, component, func, str... )                   \
do                                                                      \
{                                                                       \
    if ( (DEBUG == DEBUG_ALL ) or                                       \
         (DEBUG_ ## level == DEBUG_NONE) or                             \
         (( DEBUG_ ## level     <= DEBUG) and                           \
          ( DEBUG_ ## component == true )) )                            \
      {                                                                 \
        if (DEBUG >= DEBUG_ALL )                                        \
          {                                                             \
            switch (DEBUG_ ## level)                                    \
            {                                                           \
	    case DEBUG_NONE  : fprintf(stdout,"(none       ) "); break; \
	    case DEBUG_INFO  : fprintf(stdout,"(information) "); break; \
	    case DEBUG_TRACE : fprintf(stdout,"(trace      ) "); break; \
	    case DEBUG_FUNC  : fprintf(stdout,"(function   ) "); break; \
	    case DEBUG_ALL   : fprintf(stdout,"(all        ) "); break; \
	    default          : fprintf(stdout,"(undefine   ) "); break; \
	    }                                                           \
          }                                                             \
        fprintf(stdout,"<%s> ",func);                                   \
        if (DEBUG >= DEBUG_FUNC)                                        \
        {                                                               \
          fprintf(stdout,"In file %s, ",__FILE__);                      \
          fprintf(stdout,"at line %d, ",__LINE__);                      \
        }                                                               \
        fprintf(stdout,": ");                                           \
        fprintf(stdout,str);                                            \
        fprintf(stdout,"\n");                                           \
        fflush (stdout);                                                \
      }                                                                 \
} while(0)

#else
// No debug

#  define log_printf(level, component, func, str... )                                 \
do                                                                                    \
{                                                                                     \
} while(0)

#endif // DEBUG

#endif // !DEBUG_H
