#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>
using namespace std;

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_body_component_port_map"
  void Vhdl::set_body_component_port_map (list<string> & list_port_map      ,
					  string         name_port          ,
					  uint32_t       size_port          ,
					  string         name_signal        ,
					  uint32_t       size_signal        )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    if (size_port > size_signal)
      throw (ErrorMorpheo ("<Vhdl::set_body_component_port_map> size of port '"+name_port+"' ("+toString(size_port)+") is greater than size of signal '"+name_signal+"' ("+toString(size_signal)+")."));

    string str_size = "";

    // test if size is different (possible if multi write
    if (size_port != size_signal)
      str_size = std_logic_range(size_port);
    
    set_list(list_port_map, name_port + "\t=>" + name_signal+str_size);
      
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
