#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {

#undef  FUNCTION
#define FUNCTION "Read_queue::genMealy_read_queue_out_gpr"
  void Read_queue::genMealy_read_queue_out_gpr (void)
  {
    log_printf(FUNC,Read_queue,FUNCTION,"Begin");

    internal_READ_QUEUE_OUT_DATA_RA_VAL = (// Previous value
					   _queue_head->_data_ra_val or
					   // Test if have already access at the registerfile
					   (_queue_head->_read_ra_val           and
					    PORT_READ(in_GPR_READ_ACK      [0]) and
					    PORT_READ(in_GPR_READ_DATA_VAL [0]))
					   );

    log_printf(TRACE,Read_queue,FUNCTION," * internal_READ_QUEUE_OUT_DATA_RA_VAL   : %d",internal_READ_QUEUE_OUT_DATA_RA_VAL);
    log_printf(TRACE,Read_queue,FUNCTION,"   * _queue_head->_data_ra_val           : %d",_queue_head->_data_ra_val);
    log_printf(TRACE,Read_queue,FUNCTION,"   * _queue_head->_read_ra_val           : %d",_queue_head->_read_ra_val);
    log_printf(TRACE,Read_queue,FUNCTION,"   * in_GPR_READ_ACK      [0]            : %d",PORT_READ(in_GPR_READ_ACK      [0]));
    log_printf(TRACE,Read_queue,FUNCTION,"   * in_GPR_READ_DATA_VAL [0]            : %d",PORT_READ(in_GPR_READ_DATA_VAL [0]));

    internal_READ_QUEUE_OUT_DATA_RB_VAL = (_queue_head->_data_rb_val or
					   (_queue_head->_read_rb_val           and
					    PORT_READ(in_GPR_READ_ACK      [1]) and
					    PORT_READ(in_GPR_READ_DATA_VAL [1]))
					   );

    log_printf(TRACE,Read_queue,FUNCTION," * internal_READ_QUEUE_OUT_DATA_RB_VAL   : %d",internal_READ_QUEUE_OUT_DATA_RB_VAL);
    log_printf(TRACE,Read_queue,FUNCTION,"   * _queue_head->_data_rb_val           : %d",_queue_head->_data_rb_val);
    log_printf(TRACE,Read_queue,FUNCTION,"   * _queue_head->_read_rb_val           : %d",_queue_head->_read_rb_val);
    log_printf(TRACE,Read_queue,FUNCTION,"   * in_GPR_READ_ACK      [1]            : %d",PORT_READ(in_GPR_READ_ACK      [1]));
    log_printf(TRACE,Read_queue,FUNCTION,"   * in_GPR_READ_DATA_VAL [1]            : %d",PORT_READ(in_GPR_READ_DATA_VAL [1]));
	       
    
    internal_READ_QUEUE_OUT_DATA_RA     = (// Test if have an previous access
					   (_queue_head->_data_ra_val)?
					   // if precious access, take previous data
					   _queue_head->_data_ra:
					   // else, take the read_data (don't test the validity of data)
					   PORT_READ(in_GPR_READ_DATA [0]));
    
    internal_READ_QUEUE_OUT_DATA_RB     = ((_queue_head->_data_rb_val)?
					   _queue_head->_data_rb:
					   PORT_READ(in_GPR_READ_DATA [1]));
    
    // Test all bypass
    for (uint32_t i=0; i<_param->_nb_gpr_write ; i++)
      {
	// Test if this bypass is valid
	if ( (PORT_READ (in_GPR_WRITE_VAL           [i]) == 1) and
	     (PORT_READ (in_GPR_WRITE_OOO_ENGINE_ID [i]) == _queue_head->_ooo_engine_id)
	     )
	  {
	    Tgeneral_address_t gpr_write_num_reg = PORT_READ(in_GPR_WRITE_NUM_REG [i]);
	    Tgeneral_data_t    gpr_write_data    = PORT_READ(in_GPR_WRITE_DATA    [i]);
	    
	    if (_queue_head->_num_reg_ra == gpr_write_num_reg)
	      {
		log_printf(TRACE,Read_queue,FUNCTION," * internal_READ_QUEUE_OUT_DATA_RA_VAL   - bypass hit (%d)",i);

		internal_READ_QUEUE_OUT_DATA_RA_VAL = 1;
		internal_READ_QUEUE_OUT_DATA_RA     = gpr_write_data;
	      }
	    if (_queue_head->_num_reg_rb == gpr_write_num_reg)
	      {
		log_printf(TRACE,Read_queue,FUNCTION," * internal_READ_QUEUE_OUT_DATA_RB_VAL   - bypass hit (%d)",i);
		internal_READ_QUEUE_OUT_DATA_RB_VAL = 1;
		internal_READ_QUEUE_OUT_DATA_RB     = gpr_write_data;
	      }
	  }
      }

    // Affectation out port
    PORT_WRITE(out_READ_QUEUE_OUT_DATA_RA_VAL,internal_READ_QUEUE_OUT_DATA_RA_VAL);
    PORT_WRITE(out_READ_QUEUE_OUT_DATA_RB_VAL,internal_READ_QUEUE_OUT_DATA_RB_VAL);
    PORT_WRITE(out_READ_QUEUE_OUT_DATA_RA    ,internal_READ_QUEUE_OUT_DATA_RA    );
    PORT_WRITE(out_READ_QUEUE_OUT_DATA_RB    ,internal_READ_QUEUE_OUT_DATA_RB    );

    log_printf(FUNC,Read_queue,FUNCTION,"End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
