#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace queue {


#undef  FUNCTION
#define FUNCTION "Queue::transition"
  void Queue::transition (void)
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");
    
    if (PORT_READ(in_NRESET) == 0)
      {
	_queue_control->clear();
      }
    else
      {
	// ***** PUSH to queue
	if ((PORT_READ(in_INSERT_VAL) == 1) and
	    (    internal_INSERT_ACK  == 1))
	  {
	    log_printf(TRACE,Queue,FUNCTION,"PUSH");
	    
	    // Write in reservation station
	    uint32_t index = _queue_control->push();
	    
	    log_printf(TRACE,Queue,FUNCTION," * index         : %d",index);
	    
  	    _queue_data[index] = PORT_READ(in_INSERT_DATA);
	  }
	
	// ***** POP queue
	if ((    internal_RETIRE_VAL  == 1) and
	    (PORT_READ(in_RETIRE_ACK) == 1))
	  {
	    log_printf(TRACE,Queue,FUNCTION,"POP");
	    log_printf(TRACE,Queue,FUNCTION," * index         : %d",(*_queue_control)[0]);
	    
	    _queue_control->pop();
	  }
      }

#ifdef STATISTICS
    _stat->add();
#endif    

#ifdef VHDL_TESTBENCH
    vhdl_testbench_transition ();
#endif

    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
