/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace queue {



#undef  FUNCTION
#define FUNCTION "Queue::allocation"
  void Queue::allocation (void)
  {
    string rename;

    log_printf(FUNC,Queue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Queue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface("insert"
#ifdef POSITION
							 ,IN
							 ,WEST
							 ,"Insertion of data"
#endif
							 );
      
       in_INSERT_VAL  = interface->set_signal_valack_in (VAL);
      out_INSERT_ACK  = interface->set_signal_valack_out(ACK);
       in_INSERT_DATA = interface->set_signal_in  <Tdata_t> ("data", _param->_size_data);
    }
    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface("retire"
#ifdef POSITION
							      ,IN
							      ,EAST
							      ,"Retire of data"
#endif
							      );
      
      out_RETIRE_VAL  = interface->set_signal_valack_out(VAL);
       in_RETIRE_ACK  = interface->set_signal_valack_in (ACK);
      out_RETIRE_DATA = interface->set_signal_out <Tdata_t> ("data", _param->_size_data);
    }
     
    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _queue_control = new morpheo::behavioural::generic::queue_control::Queue_Control::Queue_Control(_param->_size_queue);
    _queue_data    = new Tdata_t [_param->_size_queue];

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
