/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {


  Parameters::Parameters (uint32_t size_queue         ,
			  uint32_t nb_context         ,
			  uint32_t nb_front_end       ,
			  uint32_t nb_ooo_engine      ,
			  uint32_t nb_packet          ,
			  uint32_t size_general_data  ,
			  uint32_t size_special_data  ,
			  uint32_t nb_general_register,
			  uint32_t nb_special_register,
			  uint32_t nb_operation       ,
			  uint32_t nb_type            ,
			  uint32_t nb_gpr_write       ,
			  uint32_t nb_spr_write       ):
    _size_queue            (size_queue           ),
    _nb_context            (nb_context           ),
    _nb_front_end          (nb_front_end         ),
    _nb_ooo_engine         (nb_ooo_engine        ),
    _nb_packet             (nb_packet            ),
    _size_general_data     (size_general_data    ),
    _size_special_data     (size_special_data    ),
    _nb_general_register   (nb_general_register  ),
    _nb_special_register   (nb_special_register  ),
    _nb_operation          (nb_operation         ),
    _nb_type               (nb_type              ),
    _nb_gpr_write          (nb_gpr_write         ),
    _nb_spr_write          (nb_spr_write         ),

    _nb_gpr_read           (2                    ),
    _nb_spr_read           (1                    ),
    _size_context_id       (static_cast<uint32_t>(log2(_nb_context         ))),
    _size_front_end_id     (static_cast<uint32_t>(log2(_nb_front_end       ))),
    _size_ooo_engine_id    (static_cast<uint32_t>(log2(_nb_ooo_engine      ))),
    _size_rob_id           (static_cast<uint32_t>(log2(_nb_packet          ))),
    _size_general_register (static_cast<uint32_t>(log2(_nb_general_register))),
    _size_special_register (static_cast<uint32_t>(log2(_nb_special_register))),
    _size_operation        (static_cast<uint32_t>(log2(_nb_operation       ))),
    _size_type             (static_cast<uint32_t>(log2(_nb_type            ))),

    _have_port_context_id    (_size_context_id    > 0),
    _have_port_front_end_id  (_size_front_end_id  > 0),
    _have_port_ooo_engine_id (_size_ooo_engine_id > 0),
    _have_port_rob_id        (_size_rob_id        > 0),

    _size_internal_queue     (  _size_context_id       //_context_id   
			      + _size_front_end_id     //_front_end_id 
			      + _size_ooo_engine_id    //_ooo_engine_id
			      + _size_rob_id           //_rob_id       
			      + _size_operation        //_operation    
			      + _size_type             //_type         
			      + 1                      //_has_immediat 
			      + _size_general_data     //_immediat     
			      + 1                      //_read_ra      
			      + _size_general_register //_num_reg_ra   
			      + 1                      //_read_rb      
			      + _size_general_register //_num_reg_rb   
			      + 1                      //_read_rc      
			      + _size_special_register //_num_reg_rc   
			      + 1                      //_write_rd     
			      + _size_general_register //_num_reg_rd   
			      + 1                      //_write_re     
			      + _size_special_register //_num_reg_re   
				)
				

  {
    log_printf(FUNC,Read_queue,"Parameters","Begin");
    test();
    log_printf(FUNC,Read_queue,"Parameters","End");
  };
  
  Parameters::Parameters (Parameters & param):
    _size_queue            (param._size_queue            ),
    _nb_context            (param._nb_context            ),
    _nb_front_end          (param._nb_front_end          ),
    _nb_ooo_engine         (param._nb_ooo_engine         ),
    _nb_packet             (param._nb_packet             ),
    _size_general_data     (param._size_general_data     ),
    _size_special_data     (param._size_special_data     ),
    _nb_general_register   (param._nb_general_register   ),
    _nb_special_register   (param._nb_special_register   ),
    _nb_operation          (param._nb_operation          ),
    _nb_type               (param._nb_type               ),
    _nb_gpr_write          (param._nb_gpr_write          ),
    _nb_spr_write          (param._nb_spr_write          ),

    _nb_gpr_read           (param._nb_gpr_read           ),
    _nb_spr_read           (param._nb_spr_read           ),
    _size_context_id       (param._size_context_id       ),
    _size_front_end_id     (param._size_front_end_id     ),
    _size_ooo_engine_id    (param._size_ooo_engine_id    ),
    _size_rob_id           (param._size_rob_id           ),
    _size_general_register (param._size_general_register ),
    _size_special_register (param._size_special_register ),
    _size_operation        (param._size_operation        ),
    _size_type             (param._size_type             ),

    _have_port_context_id    (param._have_port_context_id   ),
    _have_port_front_end_id  (param._have_port_front_end_id ),
    _have_port_ooo_engine_id (param._have_port_ooo_engine_id),
    _have_port_rob_id        (param._have_port_rob_id       ),

    _size_internal_queue     (param._size_internal_queue    )
  {
    log_printf(FUNC,Read_queue,"Parameters (copy)","Begin");
    test();
    log_printf(FUNC,Read_queue,"Parameters (copy)","End");
  };

  Parameters::~Parameters () 
  {
    log_printf(FUNC,Read_queue,"~Parameters","Begin");
    log_printf(FUNC,Read_queue,"~Parameters","End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
