#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {


  void Read_queue::deallocation (void)
  {
    log_printf(FUNC,Read_queue,"deallocation","Begin");

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    delete     in_CLOCK ;
    delete     in_NRESET;

    // ~~~~~[Interface : "read_queue_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    delete     in_READ_QUEUE_IN_VAL            ;
    delete    out_READ_QUEUE_IN_ACK            ;

    if(_param->_have_port_context_id   )
      delete     in_READ_QUEUE_IN_CONTEXT_ID     ;
    if(_param->_have_port_front_end_id )
      delete     in_READ_QUEUE_IN_FRONT_END_ID   ;
    if(_param->_have_port_ooo_engine_id)
      delete     in_READ_QUEUE_IN_OOO_ENGINE_ID  ;
    if(_param->_have_port_rob_id       )
      delete     in_READ_QUEUE_IN_ROB_ID         ;
    delete     in_READ_QUEUE_IN_OPERATION      ;
    delete     in_READ_QUEUE_IN_TYPE           ;
    delete     in_READ_QUEUE_IN_HAS_IMMEDIAT   ;
    delete     in_READ_QUEUE_IN_IMMEDIAT       ;
    delete     in_READ_QUEUE_IN_READ_RA        ;
    delete     in_READ_QUEUE_IN_NUM_REG_RA     ;
    delete     in_READ_QUEUE_IN_READ_RB        ;
    delete     in_READ_QUEUE_IN_NUM_REG_RB     ;
    delete     in_READ_QUEUE_IN_READ_RC        ;
    delete     in_READ_QUEUE_IN_NUM_REG_RC     ;
    delete     in_READ_QUEUE_IN_WRITE_RD       ;
    delete     in_READ_QUEUE_IN_NUM_REG_RD     ;
    delete     in_READ_QUEUE_IN_WRITE_RE       ;
    delete     in_READ_QUEUE_IN_NUM_REG_RE     ;

    // ~~~~~[Interface : "read_queue_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    delete    out_READ_QUEUE_OUT_VAL            ;
    delete     in_READ_QUEUE_OUT_ACK            ;

    if(_param->_have_port_context_id   )
      delete    out_READ_QUEUE_OUT_CONTEXT_ID     ;
    if(_param->_have_port_front_end_id )
      delete    out_READ_QUEUE_OUT_FRONT_END_ID   ;
    if(_param->_have_port_ooo_engine_id)
      delete    out_READ_QUEUE_OUT_OOO_ENGINE_ID  ;
    if(_param->_have_port_rob_id       )
      delete    out_READ_QUEUE_OUT_ROB_ID         ;
    delete    out_READ_QUEUE_OUT_OPERATION      ;
    delete    out_READ_QUEUE_OUT_TYPE           ;
    delete    out_READ_QUEUE_OUT_HAS_IMMEDIAT   ;
    delete    out_READ_QUEUE_OUT_IMMEDIAT       ;
    delete    out_READ_QUEUE_OUT_READ_RA        ;
    delete    out_READ_QUEUE_OUT_NUM_REG_RA     ;
    delete    out_READ_QUEUE_OUT_DATA_RA_VAL    ;
    delete    out_READ_QUEUE_OUT_DATA_RA        ;
    delete    out_READ_QUEUE_OUT_READ_RB        ;
    delete    out_READ_QUEUE_OUT_NUM_REG_RB     ;
    delete    out_READ_QUEUE_OUT_DATA_RB_VAL    ;
    delete    out_READ_QUEUE_OUT_DATA_RB        ;
    delete    out_READ_QUEUE_OUT_READ_RC        ;
    delete    out_READ_QUEUE_OUT_NUM_REG_RC     ;
    delete    out_READ_QUEUE_OUT_DATA_RC_VAL    ;
    delete    out_READ_QUEUE_OUT_DATA_RC        ;
    delete    out_READ_QUEUE_OUT_WRITE_RD       ;
    delete    out_READ_QUEUE_OUT_NUM_REG_RD     ;
    delete    out_READ_QUEUE_OUT_WRITE_RE       ;
    delete    out_READ_QUEUE_OUT_NUM_REG_RE     ;

    // ~~~~~[Interface : "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    delete [] out_GPR_READ_VAL       ;
    delete []  in_GPR_READ_ACK       ;
    if(_param->_have_port_ooo_engine_id)
      delete [] out_GPR_READ_OOO_ENGINE_ID;
    delete [] out_GPR_READ_NUM_REG   ;
    delete []  in_GPR_READ_DATA      ;
    delete []  in_GPR_READ_DATA_VAL  ;

    // ~~~~~[Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    delete [] out_SPR_READ_VAL       ;
    delete []  in_SPR_READ_ACK       ;
    if(_param->_have_port_ooo_engine_id)
      delete [] out_SPR_READ_OOO_ENGINE_ID;
    delete [] out_SPR_READ_NUM_REG   ;
    delete []  in_SPR_READ_DATA      ;
    delete []  in_SPR_READ_DATA_VAL  ;

    // ~~~~~[Interface : "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    delete []  in_GPR_WRITE_VAL       ;
    if(_param->_have_port_ooo_engine_id)
      delete []  in_GPR_WRITE_OOO_ENGINE_ID;
    delete []  in_GPR_WRITE_NUM_REG   ;
    delete []  in_GPR_WRITE_DATA      ;

    // ~~~~~[Interface : "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    delete []  in_SPR_WRITE_VAL       ;
    if(_param->_have_port_ooo_engine_id)
      delete []  in_SPR_WRITE_OOO_ENGINE_ID;
    delete []  in_SPR_WRITE_NUM_REG   ;
    delete []  in_SPR_WRITE_DATA      ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    while (_queue->empty() == false)
      {
	delete _queue->front();
	_queue->pop();
      }
    delete _queue;
    delete _queue_head;
    delete _component;
    log_printf(FUNC,Read_queue,"deallocation","End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
