#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Reservation_station.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {


#undef  FUNCTION
#define FUNCTION "Reservation_station::genMoore"
  void Reservation_station::genMoore (void)
  {
    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");

    // ~~~~~[Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~
    
    // accept a new instructions when reservation_station is not full
#ifdef  SYSTEMC_VHDL_COMPATIBILITY
    for (internal_INSERT_SLOT=0; (internal_INSERT_SLOT<_param->_size_queue) and (_queue_valid[internal_INSERT_SLOT]==true); internal_INSERT_SLOT++);
    internal_INSERT_ACK = (internal_INSERT_SLOT<_param->_size_queue);
#else
    internal_INSERT_ACK = not _queue_control->full();
#endif    
    PORT_WRITE(out_INSERT_ACK, internal_INSERT_ACK);

    // ~~~~~[Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~

    uint32_t nb_slot_find = 0;
    for (uint32_t i=0; (
#ifdef  SYSTEMC_VHDL_COMPATIBILITY
			(i<_param->_size_queue) 
#else
			(i<_queue_control->nb_elt())
#endif
			and (nb_slot_find < _param->_nb_inst_retire)

			)
			; i++)
      {
	uint32_t index;
#ifdef  SYSTEMC_VHDL_COMPATIBILITY
	index = i;
#else
	index = (*_queue_control)[i];
#endif
	bool     val   = 
	  (
#ifdef  SYSTEMC_VHDL_COMPATIBILITY
	   _queue_valid [i]           and
#endif
	   _queue[index]._data_ra_val and 
	   _queue[index]._data_rb_val and 
	   _queue[index]._data_rc_val);

	if (val == true)
	  {
	    internal_RETIRE_SLOT [nb_slot_find] = i;
	    nb_slot_find ++;
	  }
      }

    for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
      {
	bool val                = i<nb_slot_find;
	internal_RETIRE_VAL [i] = val;

	PORT_WRITE(out_RETIRE_VAL [i], val);

	if (val)
	  {
	    uint32_t index;
#ifdef  SYSTEMC_VHDL_COMPATIBILITY
	    index = internal_RETIRE_SLOT [i];
#else
	    index = (*_queue_control)[internal_RETIRE_SLOT [i]];
#endif
	    if (_param->_have_port_context_id)
	    PORT_WRITE(out_RETIRE_CONTEXT_ID    [i],_queue[index]._context_id);
	    if (_param->_have_port_front_end_id)
	    PORT_WRITE(out_RETIRE_FRONT_END_ID  [i],_queue[index]._front_end_id);
	    if (_param->_have_port_ooo_engine_id)
	    PORT_WRITE(out_RETIRE_OOO_ENGINE_ID [i],_queue[index]._ooo_engine_id);
	    if (_param->_have_port_rob_id)
	    PORT_WRITE(out_RETIRE_ROB_ID        [i],_queue[index]._rob_id);
	    PORT_WRITE(out_RETIRE_OPERATION     [i],_queue[index]._operation);
	    PORT_WRITE(out_RETIRE_TYPE          [i],_queue[index]._type);
	    PORT_WRITE(out_RETIRE_HAS_IMMEDIAT  [i],_queue[index]._has_immediat);
	    PORT_WRITE(out_RETIRE_IMMEDIAT      [i],_queue[index]._immediat);
	    PORT_WRITE(out_RETIRE_DATA_RA       [i],_queue[index]._data_ra);
	    PORT_WRITE(out_RETIRE_DATA_RB       [i],_queue[index]._data_rb);
	    PORT_WRITE(out_RETIRE_DATA_RC       [i],_queue[index]._data_rc);
	    PORT_WRITE(out_RETIRE_WRITE_RD      [i],_queue[index]._write_rd);
	    PORT_WRITE(out_RETIRE_NUM_REG_RD    [i],_queue[index]._num_reg_rd);
	    PORT_WRITE(out_RETIRE_WRITE_RE      [i],_queue[index]._write_re);
	    PORT_WRITE(out_RETIRE_NUM_REG_RE    [i],_queue[index]._num_reg_re);
	  }
      }

    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
