#ifdef VHDL

#ifndef morpheo_behavioural_Vhdl_h
#define morpheo_behavioural_Vhdl_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
#include "Behavioural/include/Environnement.h"
#include "Behavioural/include/Direction.h"
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Common/include/ErrorMorpheo.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  string std_logic        (uint32_t size);
  string std_logic_conv   (uint32_t size, string   value);
  string std_logic_conv   (uint32_t size, uint32_t value);
  string std_logic_range  (uint32_t size, uint32_t max , uint32_t min  );
  string std_logic_range  (uint32_t max , uint32_t min  );
  string std_logic_range  (uint32_t size);
  string std_logic_others (uint32_t size, uint32_t cst  );

  class Vhdl
  {
    // -----[fields ]----------------------------------------------------
  private   : const string     _name                         ;

  private   : list<string>     _list_library_work            ;
  private   : list<string>     _list_signal                  ;
  private   : list<string>     _list_type                    ;
  private   : list<string>     _list_alias                   ;
  private   : list<string>     _list_port                    ;
  private   : list<string>     _list_body                    ;
    
    // -----[methods ]---------------------------------------------------
  public    :                  Vhdl                        (string name);
  public    :                  ~Vhdl                       ();
						           
  public    : void             generate_file               (void);
  public    : void             generate_file               (bool generate_package,
							    bool generate_model  );

  private   : void             generate_file_package       (void);
  private   : void             generate_file_model         (void);
  
  private   : string           get_package                 (uint32_t    depth                 ,
							    string      filename              ,
							    string      package_name          ,
							    string      entity_name           );
  private   : string           get_model                   (uint32_t    depth                 ,
							    string      filename              ,
							    string      entity_name           ,
							    string      architecture_name     );
  private   : string           get_header                  (uint32_t    depth                 ,
							    string      filename              );
  private   : string           get_entity                  (uint32_t    depth                 ,
							    string      name                  );
  private   : string           get_architecture            (uint32_t    depth                 , 
							    string      name                  ,
							    string      entity_name           );
  private   : string           get_component               (uint32_t    depth                 ,
							    string      name                  );

  private   : string           get_port                    (uint32_t    depth                 );
  public    : void             set_port                    (string      name                  ,
							    direction_t direction             ,
							    string      type                  );
  public    : void             set_port                    (string      name                  ,
							    direction_t direction             ,
							    uint32_t    size                  );
  private   : string           get_signal                  (uint32_t    depth                 );
  public    : void             set_signal                  (string      name                  ,
							    string      type                  );
  public    : void             set_signal                  (string      name                  ,
							    uint32_t    signal                );
  public    : void             set_signal                  (string      name                  ,
							    string      type                  ,
							    string      init                  );
  public    : void             set_signal                  (string      name                  ,
							    uint32_t    size                  ,
							    string      init                  );
  public    : void             set_signal                  (string      name                  ,
							    uint32_t    size                  ,
							    uint32_t    init                  );
  public    : void             set_constant                (string      name                  ,
							    string      type                  ,
							    string      init                  );
  public    : void             set_constant                (string      name                  ,
							    uint32_t    size                  ,
							    string      init                  );
  public    : void             set_constant                (string      name                  ,
							    uint32_t    size                  ,
							    uint32_t    init                  );

  private   : string           get_type                    (uint32_t    depth                 );
  public    : void             set_type                    (string      name                  ,
							    string      type                  );
  private   : string           get_alias                   (uint32_t    depth                 );
  public    : void             set_alias                   (string      name1                 ,
							    string      type1                 ,
							    string      name2                 ,
							    string      range2                );
  public    : void             set_alias                   (string      name1                 ,
							    uint32_t    size1                 ,
							    string      name2                 ,
							    string      range2                );

  public    : string           get_list                    (list<string> liste                ,
							    uint32_t     depth                ,
							    string       separator            ,
							    bool         last_separator       );
  public    : void             set_list                    (list<string> & liste              ,
							    string         text               );

  private   : string           get_body                    (uint32_t       depth              );
  public    : void             set_body                    (string         text               );

  public    : void             set_body_component          (string         name_instance      ,
							    string         name_component     ,
							    list<string>   list_port_map      );
  public    : void             set_body_component_port_map (list<string> & list_port_map      ,
							    string         name_port          ,
							    uint32_t       size_port          ,
							    string         name_signal        ,
							    uint32_t       size_signal        );

  private   : string           get_library_ieee            (uint32_t    depth                 );
  private   : string           get_library_work            (uint32_t    depth                 );
  public    : void             set_library_work            (string      package_name          );

  private   : string           direction_toString          (direction_t direction);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
#endif
