#ifdef STATISTICS
#include "Behavioural/include/Stat.h"

namespace morpheo {
namespace behavioural {
  counter_t * Stat::alloc_operand (counter_type_t type, std::string varname, std::string unit, std::string description)
  {
    if (not is_valid_var (varname))
      throw(ERRORMORPHEO("Stat::alloc_operand",_("Variable is not valid.")));

    counter_t * counter = new counter_t;
    var_t       var;

    var.counter     = counter;
    var.type        = type;
    var.name        = varname;
    var.unit        = unit;
    var.description = description;

    // insertion dans la table
    (*_list_operand) [varname] = var;

    *counter        = 0;
    
    return counter;
  }
};
};
#endif
