#ifndef morpheo_behavioural_Parameters_h
#define morpheo_behavioural_Parameters_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <math.h>
#include "Behavioural/include/Environnement.h"
#include "Common/include/ErrorMorpheo.h"
#include "Common/include/ToString.h"
#include "Common/include/Log2.h"
#include "Common/include/Debug.h"

namespace morpheo     {
namespace behavioural {

  // Virtual Class - Interface of each component
  class Parameters
  {
    // -----[fields ]----------------------------------------------------
  public   : static const uint32_t   _size_exception      = 4 ;
  public   : static const uint32_t   _size_dcache_address = 32;
  public   : static const uint32_t   _size_dcache_type    = 4;
  public   : static const uint32_t   _size_dcache_error   = 1;

    // -----[methods ]---------------------------------------------------
  public   :                  Parameters            (void);
  public   : virtual          ~Parameters           ();
	
    // methods to print and test parameters
  public   : virtual std::string   print                 (uint32_t depth) = 0;
  public   : virtual std::string   msg_error             (void) = 0;

    // methods to generate configuration file

    
    // methods to test
  public   :         void     test                  (void);
  public   :         bool     is_natural            (double  val );
  public   :         bool     is_positive           (double  val );
  public   :         bool     is_multiple           (uint32_t val1,
		 	    	                     uint32_t val2);
  public   :         bool     is_between_inclusive  (uint32_t val,
						     uint32_t min,
						     uint32_t max);
  public   :         bool     is_between_exclusive  (uint32_t val,
						     uint32_t min,
						     uint32_t max);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
