#ifdef STATISTICS

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Statistics.h"
#include <time.h>
#include <sstream>
#include <fstream>

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Statistics::generate_file"
  void Statistics::generate_file(std::string stat)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::stringstream filename;
    filename << _name << ".stat";

    std::cout << "Generate file \""<< filename.str() << "\"" << std::endl;

    std::ofstream file;
    file.open(filename.str().c_str(),std::ios::out | std::ios::trunc);

    time_t current_time;
    time (&current_time);

    // print header
    file << "<!-- "                                                    << std::endl
	 << "\tfile        : " << filename.str()                       << std::endl
	 << "\tdate        : " << ctime (&current_time )
	 << "\tcomment     : it's a autogenerated file : don't modify" << std::endl
	 << "-->"                                                      << std::endl
	 <<                                                               std::endl;
	 
    file << stat;
    
    file.close();

    log_printf(FUNC,Behavioural,FUNCTION,"End");
  }

#undef  FUNCTION
#define FUNCTION "Statistics::generate_file"
  void Statistics::generate_file(void)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    generate_file(print(0));

    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
