#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_library_ieee"
  std::string Vhdl::get_library_ieee (uint32_t depth)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string        tab = std::string(depth,'\t');
    std::ostringstream text;

    text << tab                                       << std::endl
	 << tab << "library ieee;"                    << std::endl
         << tab << "use ieee.numeric_bit.all;"        << std::endl
         << tab << "use ieee.numeric_std.all;"        << std::endl
	 << tab << "use ieee.std_logic_1164.all;"     << std::endl
         << tab << "use ieee.std_logic_arith.all;"    << std::endl
         << tab << "use ieee.std_logic_misc.all;"     << std::endl
         << tab << "--use ieee.std_logic_signed.all;" << std::endl
         << tab << "use ieee.std_logic_unsigned.all;" << std::endl
         << tab << "--use ieee.std_logic_textio.all;" << std::endl;
      
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
