#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_architecture"
  std::string Vhdl::get_architecture (uint32_t depth      ,
				 std::string   name       ,
				 std::string   entity_name)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string        tab = std::string(depth,'\t');
    std::ostringstream text;

    text << tab << "architecture " << name << " of " << entity_name << " is" << std::endl
	 << tab << get_type     (depth+1)                                    << std::endl
	 << tab << get_signal   (depth+1)                                    << std::endl
	 << tab << get_alias    (depth+1)                                    << std::endl
	 << tab << "begin"                                                   << std::endl
	 << tab << get_body     (depth+1)                                    << std::endl
	 << tab << "end " << name << ";"                                     << std::endl;

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
