#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_package"
  std::string Vhdl::get_package(uint32_t depth       ,
			   std::string   filename    ,
			   std::string   package_name,
			   std::string   entity_name )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string        tab = std::string(depth,'\t');
    std::ostringstream text;

    text << tab << get_header       (depth,filename)                      << std::endl
	 << tab << get_library_ieee (depth)                               << std::endl
	 << tab << "package " << package_name << " is"                    << std::endl
	 << tab << get_component    (depth+1,entity_name)                 << std::endl
	 << tab << "end " << package_name << ";"                          << std::endl;

    log_printf(FUNC,Behavioural,FUNCTION,"End");
    
    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
