#ifndef morpheo_behavioural_Component_h
#define morpheo_behavioural_Component_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
#include <map>
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
//#include "Behavioural/include/Description.h"
#include "Behavioural/include/Entity.h"
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Usage.h"

namespace morpheo              {
namespace behavioural          {

  typedef uint8_t Tinstance_t;

#define INSTANCE_NONE         0x0
#define INSTANCE_LIBRARY      0x1
#define INSTANCE_COMPONENT    0x2
#define INSTANCE_POSITION     0x4
#define INSTANCE_ALL          0x7

  typedef struct
  {
    public : Tinstance_t _instance;
    public : Entity    * _entity  ;
  } Tcomponent_t;    
  
  class Component
  {
    // -----[fields ]----------------------------------------------------
  private   : const Tusage_t        _usage;
  private   : Entity              * _entity        ;
  private   : list<Tcomponent_t*> * _list_component;

    // -----[methods ]---------------------------------------------------
  public    :                       Component         (Tusage_t usage=USE_ALL);
  public    :                       Component         (const Component & component);
  public    :                       ~Component        ();

  public    : Entity *              set_entity        (std::string        name   
						       ,std::string        type  
#ifdef POSITION
						       ,schema_t      schema
#endif
						       );
  private   : std::string                get_entity        (void);

  public    : void                  set_component     (Component * component
#ifdef POSITION
						       ,uint32_t   pos_x  
						       ,uint32_t   pos_y  
						       ,uint32_t   size_x 
						       ,uint32_t   size_y 
#endif
						       ,Tinstance_t instance=INSTANCE_ALL 
						       );

  private   : std::string                get_component     (void);

  private   : Entity *              find_entity       (std::string name);
//private   : Interface *           find_interface    (std::string   name  , 
//						       Entity * entity);

#ifdef VHDL
  public    : void                  vhdl_instance     (Vhdl * & vhdl);
#endif


  private   : Signal *              signal_internal   (Entity * entity_productor,
						       Signal * signal_productor);

  public    : void                  port_map          (std::string component_src ,
						       std::string port_src      ,
						       std::string component_dest,
						       std::string port_dest    );
  public    : void                  port_map          (std::string component_src ,
						       std::string port_src      );

  public    : bool                  test_map          (void);

#ifdef POSITION
  public    : void                  interface_map     (std::string component_src ,
						       std::string port_dest,
						       std::string component_dest,
						       std::string port_dest     );

  public    : XML                   toXML             (void);

  public    : void                  generate_file     (void);
#endif    
  public    : friend ostream&       operator<<        (ostream& output_stream,
  					  	       morpheo::behavioural::Component & x);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
