#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_signal"

  void Vhdl::set_signal (std::string      name     ,
			 std::string      type     )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_list(_list_signal, "signal "+ name + "\t: " + type);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void Vhdl::set_signal (std::string      name     ,
			 uint32_t    size     )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_signal(name,std_logic(size));
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  }

  void Vhdl::set_signal (std::string      name     ,
			 std::string      type     ,
			 std::string      init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    _list_signal.push_back ("signal "+ name+"\t: "+type+"\t:= "+init);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void Vhdl::set_signal (std::string      name     ,
			 uint32_t    size     ,
			 std::string      init     )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_signal(name,std_logic(size),init);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  void Vhdl::set_signal (std::string      name     ,
			 uint32_t    size     ,
			 uint32_t    init     )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_signal(name,std_logic(size),std_logic_conv(size,init));
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
