/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {


#ifdef SYSTEMC
  Counter::Counter (sc_module_name name,
#else
  Counter::Counter (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
			      morpheo::behavioural::generic::counter::Parameters param ):
			      _name              (name)
			      ,_param            (param)
  {
    log_printf(FUNC,Counter,"Counter","Begin");

#ifdef SYSTEMC
    allocation ();
#endif

#ifdef STATISTICS
    // Allocation of statistics
    statistics_declaration(param_statistics);
#endif

#ifdef VHDL
    // generate the vhdl
    vhdl();
#endif

#ifdef SYSTEMC

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();
#endif

    SC_METHOD (genMealy);
    dont_initialize ();
    for (uint32_t i=0; i<_param._nb_port; i++)
      sensitive << *(in_COUNTER_DATA   [i])
		<< *(in_COUNTER_ADDSUB [i]);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	(*(out_COUNTER_DATA [i])) (*(in_COUNTER_DATA   [i]));
	(*(out_COUNTER_DATA [i])) (*(in_COUNTER_ADDSUB [i]));
      }
#endif    

#endif
    log_printf(FUNC,Counter,"Counter","End");
  };
  
  Counter::~Counter (void)
  {
    log_printf(FUNC,Counter,"~Counter","Begin");
#ifdef SYSTEMC
    deallocation ();
#endif

#ifdef STATISTICS
    delete _stat;
#endif
    log_printf(FUNC,Counter,"~Counter","End");
  };

}; // end namespace counter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
