#ifndef morpheo_behavioural_SPR_access_mode_h
#define morpheo_behavioural_SPR_access_mode_h

#include "Common/include/BitManipulation.h"
#include "Common/include/ErrorMorpheo.h"
#include "Behavioural/include/Constants.h"
#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {

  typedef struct
  {
    Tgeneral_data_t _group;
    Tgeneral_data_t _register;
  } spr_address_t;


  class SPR_access_mode
  {
  private : spr_access_mode_t   ** _spr_generic;
  private : uint32_t             * _max_register_by_group;

  public  : SPR_access_mode();
  public  : ~SPR_access_mode();

  public  : spr_address_t translate_address (Tgeneral_data_t address);

  public  : bool          valid (uint32_t num_group, uint32_t num_reg);
  public  : bool          valid (spr_address_t address);
  public  : bool          read  (spr_address_t address, Tcontrol_t SM, Tcontrol_t SUMRA);
  public  : bool          write (spr_address_t address, Tcontrol_t SM, Tcontrol_t SUMRA);

  public  : void          implement_group (uint32_t num_group, uint32_t nb_reg);
  public  : uint32_t      implement_group (uint32_t num_group);
  public  : void          change_mode     (uint32_t num_group, uint32_t num_reg, spr_access_mode_t new_mode);
  };
  

}; // end namespace behavioural
}; // end namespace morpheo              
#endif

