#ifndef morpheo_behavioural_Types_h
#define morpheo_behavioural_Types_h

#include "Common/include/Types.h"
#include "Behavioural/include/Constants.h"

namespace morpheo {
namespace behavioural {
  
  //============================================
  // Type definition
  //============================================

  // ***** general
  typedef bool          Tcontrol_t;
  typedef uint32_t      Toperation_t;
//typedef uint32_t      Tdestination1_t;
//typedef uint32_t      Tdestination2_t;
//typedef uint32_t      Texec_flag_t;
//typedef bool          Texec_excep_t;
//typedef uint32_t      Tcondition_t;
//typedef uint32_t      Tbranch_state_t;

  typedef uint32_t      Texception_t;
  typedef uint32_t      Tcontext_t;
  typedef uint32_t      Tpacket_t;
  typedef uint32_t      Ttype_t;

  // ***** Register
  typedef uint32_t      Tgeneral_address_t;
  typedef uint32_t      Tgeneral_data_t;
  typedef uint32_t      Tspecial_address_t;
  typedef uint32_t      Tspecial_data_t;

  // ***** component dependant
  // ~~~~~load store queue
  typedef uint32_t      Taccess_t;
  typedef uint32_t      Tlsq_ptr_t;
  typedef uint32_t      Tdcache_address_t;
  typedef uint32_t      Tdcache_data_t;
  typedef bool          Tdcache_error_t;
  typedef uint32_t      Tdcache_type_t;

  //----------------------------------------------[ spr_mode_access ]-----
  class spr_access_mode_t
  {
  public : uint8_t _user_access_mode      ;
  public : uint8_t _supervisor_access_mode;
    
  public : spr_access_mode_t (uint32_t user_access_mode       = SPR_ACCESS_MODE_NONE,
			      uint32_t supervisor_access_mode = SPR_ACCESS_MODE_NONE)
    {
      _user_access_mode       = user_access_mode      ;
      _supervisor_access_mode = supervisor_access_mode;
    }
  };

  inline Tcontext_t get_num_thread (Tcontext_t num_context_id ,
				    uint32_t   size_context_id,
				    Tcontext_t num_front_end_id ,
				    uint32_t   size_front_end_id,
				    Tcontext_t num_ooo_engine_id ,
				    uint32_t   size_ooo_engine_id)
  {
    return ((num_ooo_engine_id << (size_context_id + size_front_end_id)) |
	    (num_front_end_id  << (size_context_id)) |
	    (num_context_id));
  }
				    


}; // end namespace behavioural
}; // end namespace morpheo              

#endif
