#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_execute_queue_Execute_queue_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_execute_queue_Execute_queue_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include <queue>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


  class execute_queue_entry_t
  {
  public  : Tcontext_t         _context_id   ;
  public  : Tcontext_t         _front_end_id ;
  public  : Tcontext_t         _ooo_engine_id;
  public  : Tpacket_t          _packet_id    ;
//public  : Toperation_t       _operation    ;
//public  : Ttype_t            _type         ;
  public  : Tspecial_data_t    _flags        ;
  public  : Texception_t       _exception    ;
  public  : Tcontrol_t         _no_sequence  ;
  public  : Tgeneral_data_t    _address      ;
    
  public  : execute_queue_entry_t (Tcontext_t         context_id   ,
				   Tcontext_t         front_end_id ,
				   Tcontext_t         ooo_engine_id,
				   Tpacket_t          packet_id    ,
			         //Toperation_t       operation    ,
			         //Ttype_t            type         ,
				   Tspecial_data_t    flags        ,
				   Texception_t       exception    ,
				   Tcontrol_t         no_sequence  ,
				   Tgeneral_data_t    address      )
    {
      _context_id    = context_id   ;
      _front_end_id  = front_end_id ;
      _ooo_engine_id = ooo_engine_id;
      _packet_id     = packet_id    ;
    //_operation     = operation    ;
    //_type          = type         ;
      _flags         = flags        ;
      _exception     = exception    ;
      _no_sequence   = no_sequence  ;
      _address       = address      ;
    };
  };


  class Execute_queue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;

  private   : counter_t                      * _stat_use_queue;
  private   : counter_t                      * _stat_average_use_queue;
  private   : counter_t                      * _stat_percent_use_queue;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // -----[ Interface "Execute_queue_in" ]------------------------------
  public    : SC_IN (Tcontrol_t        )    *  in_EXECUTE_QUEUE_IN_VAL           ;
  public    : SC_OUT(Tcontrol_t        )    * out_EXECUTE_QUEUE_IN_ACK           ;
  public    : SC_IN (Tcontext_t        )    *  in_EXECUTE_QUEUE_IN_CONTEXT_ID    ;
  public    : SC_IN (Tcontext_t        )    *  in_EXECUTE_QUEUE_IN_FRONT_END_ID  ;
  public    : SC_IN (Tcontext_t        )    *  in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID ;
  public    : SC_IN (Tpacket_t         )    *  in_EXECUTE_QUEUE_IN_PACKET_ID     ;
//public    : SC_IN (Toperation_t      )    *  in_EXECUTE_QUEUE_IN_OPERATION     ;
//public    : SC_IN (Ttype_t           )    *  in_EXECUTE_QUEUE_IN_TYPE          ;
  public    : SC_IN (Tspecial_data_t   )    *  in_EXECUTE_QUEUE_IN_FLAGS         ;
  public    : SC_IN (Texception_t      )    *  in_EXECUTE_QUEUE_IN_EXCEPTION     ;
  public    : SC_IN (Tcontrol_t        )    *  in_EXECUTE_QUEUE_IN_NO_SEQUENCE   ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_EXECUTE_QUEUE_IN_ADDRESS       ;

    // -----[ Interface "Execute_queue_out" ]-----------------------------
  public    : SC_OUT(Tcontrol_t        )    * out_EXECUTE_QUEUE_OUT_VAL          ;
  public    : SC_IN (Tcontrol_t        )    *  in_EXECUTE_QUEUE_OUT_ACK          ;
  public    : SC_OUT(Tcontext_t        )    * out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ;
  public    : SC_OUT(Tcontext_t        )    * out_EXECUTE_QUEUE_OUT_FRONT_END_ID ;
  public    : SC_OUT(Tcontext_t        )    * out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID;
  public    : SC_OUT(Tpacket_t         )    * out_EXECUTE_QUEUE_OUT_PACKET_ID    ;
//public    : SC_OUT(Toperation_t      )    * out_EXECUTE_QUEUE_OUT_OPERATION    ;
//public    : SC_OUT(Ttype_t           )    * out_EXECUTE_QUEUE_OUT_TYPE         ;
  public    : SC_OUT(Tspecial_data_t   )    * out_EXECUTE_QUEUE_OUT_FLAGS        ;
  public    : SC_OUT(Texception_t      )    * out_EXECUTE_QUEUE_OUT_EXCEPTION    ;
  public    : SC_OUT(Tcontrol_t        )    * out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_EXECUTE_QUEUE_OUT_ADDRESS      ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    
    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : queue<execute_queue_entry_t *> * _queue;
    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                       internal_EXECUTE_QUEUE_IN_ACK ;
  private   : Tcontrol_t                       internal_EXECUTE_QUEUE_OUT_VAL;
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Execute_queue);
#endif
  public  :          Execute_queue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Execute_queue             (void);
					       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void     transition                (void);
  public  : void     genMoore                  (void);
#endif					       
#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
