#ifndef morpheo_behavioural_generic_shifter_Shifter_h
#define morpheo_behavioural_generic_shifter_Shifter_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"

#include "Behavioural/Generic/Shifter/include/Parameters.h"
#include "Behavioural/Generic/Shifter/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Component.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  class Shifter 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const std::string     _name;

  protected : const Parameters _param;
#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK             ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET            ;

    // Interface "shifter"
  public    : SC_IN (Tdata_t)              **  in_SHIFTER_DATA      ;
  public    : SC_IN (Tshift_t)             **  in_SHIFTER_SHIFT     ;
  public    : SC_IN (Tdirection_t)         **  in_SHIFTER_DIRECTION ;
  public    : SC_IN (Ttype_t)              **  in_SHIFTER_TYPE      ;
  public    : SC_IN (Tcarry_t)             **  in_SHIFTER_CARRY     ;
  public    : SC_IN (Tcontrol_t)           **  in_SHIFTER_CARRY_IN  ; // Completion == type bool
  public    : SC_IN (Tdata_t)              **  in_SHIFTER_COMPLETION; // Completion != type bool
  public    : SC_OUT(Tdata_t)              ** out_SHIFTER_DATA      ;
    
    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Shifter);
#endif

  public  :          Shifter              (
#ifdef SYSTEMC
					   sc_module_name                                name,
#else					       
					   std::string                                   name,
#endif					       
#ifdef STATISTICS
					   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
					   Parameters                                    param );
    
  public  :          Shifter              (Parameters param );
  public  :          ~Shifter             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
  public  : void     transition                (void);
#endif
  public  : void     genMealy_shift            (void);
#endif					       
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace shifter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
