#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface_fifo.h"

namespace morpheo              {
namespace behavioural          {

  std::string Interface_fifo::testbench_test (Vhdl * & vhdl,
					 std::string   counter_name,
					 std::string   reset_name  )
  {
    log_printf(FUNC,Behavioural,"testbench_test","Begin");
    std::string test_name;
    
    if (_test_exhaustive == true)
      test_name = Interface::testbench_test(vhdl,counter_name,reset_name);
    else
      {
	vhdl->set_body("");
	vhdl->set_body("-- Test partial");
	vhdl->set_body("");

	       test_name        = testbench_test_name        (vhdl);
	std::string test_name_tmp    = test_name+"_tmp";
	std::string test_name_ok     = testbench_test_ok          (vhdl);
 	std::string test_transaction = testbench_test_transaction (vhdl);

	vhdl->set_signal(test_name_tmp,1);

	if (_list_cycle->empty()== false)
	  {
	    vhdl->set_body ("with "+counter_name+" select");
	    vhdl->set_body ("\t"+test_name_tmp+" <=");
	
	    std::list<uint32_t>::iterator i = _list_cycle->begin();
	    
	    while (i != _list_cycle->end())
	      {
		vhdl->set_body ("\t"+test_transaction+" and "+test_name_ok+" when "+toString(*i)+",");
		++i;
	      }
	    vhdl->set_body ("\tnot "+test_transaction+" when others;");
	  }
	else
	  vhdl->set_body (test_name_tmp+" <= not "+test_transaction+";");
	
	vhdl->set_body("");
	vhdl->set_body(test_name + " <= '1' when ("+reset_name+" = '0') else "+test_name_tmp+";");

#ifdef VHDL_TESTBENCH_ASSERT
	if (_list_cycle->empty()== false)
	  {
	    vhdl->set_body("");
	    vhdl->set_body("-- Assert ...");
	    vhdl->set_body("");

	    uint32_t                 j = 0;
	    std::list<uint32_t>::iterator i = _list_cycle->begin();
	    
	    while (i != _list_cycle->end())
	      {
		vhdl->set_body("assert not (("+counter_name+" = "+toString(*i)+" and "+test_name+" = '1')) report \"***** <"+_name+"> Test number "+toString(j)+" is OK     *****\" severity NOTE;");
		vhdl->set_body("assert not (("+counter_name+" = "+toString(*i)+" and "+test_name+" = '0')) report \"@@@@@ <"+_name+"> Test number "+toString(j)+" is KO !!! @@@@@\" severity NOTE;");
		j++;
		++i;
	      }

	    vhdl->set_body("");
	  }
#endif
      }

    log_printf(FUNC,Behavioural,"testbench_test","End");

    return test_name;

  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
