/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interfaces.h"

namespace morpheo              {
namespace behavioural          {

  Interfaces::Interfaces  (std::string   name,
			   Tusage_t usage):
    _name  (name),
    _usage (usage)
  {
    log_printf(FUNC,Behavioural,"Interfaces","Begin");
    _list_interface = new std::list<Interface_fifo*>;
    log_printf(FUNC,Behavioural,"Interfaces","End");
  };

  Interfaces::Interfaces  (const Interfaces & interfaces) :
    _name  (interfaces._name),
    _usage (interfaces._usage)
  {
    log_printf(FUNC,Behavioural,"Interfaces (copy)","Begin");
    _list_interface = interfaces._list_interface;
    log_printf(FUNC,Behavioural,"Interfaces (copy)","End");
  };
  
  Interfaces::~Interfaces ()
  {
    log_printf(FUNC,Behavioural,"~Interfaces","Begin");

#ifdef VHDL_TESTBENCH
    if (_usage & USE_VHDL_TESTBENCH)
      testbench_generate_file ();
#endif

    if (_list_interface->empty()== false)
      {
	std::list<Interface_fifo*>::iterator i     = _list_interface->begin();

	while (i != _list_interface->end())
	  {
	    delete (*i);
	    ++i;
	  }
      }

    delete _list_interface;
    log_printf(FUNC,Behavioural,"~Interfaces","End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              
