/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  std::string Parameters::print (uint32_t depth)
  {
    XML xml ("shifter");

    xml.balise_open("shifter");
    xml.singleton_begin("size_data  "); xml.attribut("value",toString(_size_data  )); xml.singleton_end();
    xml.singleton_begin("nb_port    "); xml.attribut("value",toString(_nb_port    )); xml.singleton_end();
    xml.singleton_begin("shift_value"); xml.attribut("value",toString(_shift_value)); xml.singleton_end();
    xml.singleton_begin("rotate     "); xml.attribut("value",toString(_rotate     )); xml.singleton_end();
    xml.singleton_begin("direction  "); xml.attribut("value",toString(_direction  )); xml.singleton_end();
    xml.singleton_begin("carry      "); xml.attribut("value",toString(_carry      )); xml.singleton_end();
    
    return xml.get_body(depth);
  };

  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::generic::shifter::Parameters & x)
  {
    output_stream << x.print(0);
    
    return output_stream;
  };

}; // end namespace shifter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
