#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Load_store_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {



#undef  FUNCTION
#define FUNCTION "Load_store_unit::allocation"
  void Load_store_unit::allocation (void)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");

    _component   = new Component ();

    Entity * entity = _component->set_entity (_name       
					      ,"Load_store_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }
    // ~~~~~[Interface "memory_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface("memory_in"
#ifdef POSITION
							      ,IN
							      ,WEST
							      ,"Instruction from Reservations station"
#endif
							      );

   in_MEMORY_IN_VAL                   = interface->set_signal_valack_in        (VAL);
  out_MEMORY_IN_ACK                   = interface->set_signal_valack_out       (ACK);

  if (_param->_have_port_context_id)
   in_MEMORY_IN_CONTEXT_ID            = interface->set_signal_in  <Tcontext_t        > ("context_id"   ,_param->_size_context_id       );
  if (_param->_have_port_front_end_id)
   in_MEMORY_IN_FRONT_END_ID          = interface->set_signal_in  <Tcontext_t        > ("front_end_id" ,_param->_size_front_end_id     );
  if (_param->_have_port_ooo_engine_id)
   in_MEMORY_IN_OOO_ENGINE_ID         = interface->set_signal_in  <Tcontext_t        > ("ooo_engine_id",_param->_size_ooo_engine_id    );
  if (_param->_have_port_packet_id)
   in_MEMORY_IN_PACKET_ID             = interface->set_signal_in  <Tpacket_t         > ("packet_id"    ,_param->_size_packet_id       );
   in_MEMORY_IN_OPERATION             = interface->set_signal_in  <Toperation_t      > ("operation"   ,_param->_size_operation        );
   in_MEMORY_IN_STORE_QUEUE_PTR_WRITE = interface->set_signal_in  <Tlsq_ptr_t        > ("store_queue_ptr_write" ,_param->_size_address_store_queue+1); // +1 cf load_queue usage
   in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE  = interface->set_signal_in  <Tlsq_ptr_t        > ("load_queue_ptr_write"  ,_param->_size_address_load_queue );
// in_MEMORY_IN_HAS_IMMEDIAT          = interface->set_signal_in  <Tcontrol_t        > ("has_immediat",1                              );
   in_MEMORY_IN_IMMEDIAT              = interface->set_signal_in  <Tgeneral_data_t   > ("immediat"    ,_param->_size_general_data     );
   in_MEMORY_IN_DATA_RA               = interface->set_signal_in  <Tgeneral_data_t   > ("data_ra"     ,_param->_size_general_data     );
   in_MEMORY_IN_DATA_RB               = interface->set_signal_in  <Tgeneral_data_t   > ("data_rb"     ,_param->_size_general_data     );
// in_MEMORY_IN_DATA_RC               = interface->set_signal_in  <Tspecial_data_t   > ("data_rc"     ,_param->_size_special_data     );
//    in_MEMORY_IN_WRITE_RD              = interface->set_signal_in  <Tcontrol_t        > ("write_rd"    ,1                              );
   in_MEMORY_IN_NUM_REG_RD            = interface->set_signal_in  <Tgeneral_address_t> ("num_reg_rd"  ,1                              );
// in_MEMORY_IN_WRITE_RE              = interface->set_signal_in  <Tcontrol_t        > ("write_re"    ,1                              );
// in_MEMORY_IN_NUM_REG_RE            = interface->set_signal_in  <Tspecial_address_t> ("num_reg_re"  ,1                              );
    }

    // ~~~~~[Interface "memory_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface("memory_out"
#ifdef POSITION
							      ,OUT
							      ,EAST
							      ,"Instruction to write queue"
#endif
							      );

      out_MEMORY_OUT_VAL           = interface->set_signal_valack_out(VAL);
       in_MEMORY_OUT_ACK           = interface->set_signal_valack_in (ACK);
      if (_param->_have_port_context_id)       
      out_MEMORY_OUT_CONTEXT_ID    = interface->set_signal_out <Tcontext_t        > ("context_id"    ,_param->_size_context_id       );
      if (_param->_have_port_front_end_id)     
      out_MEMORY_OUT_FRONT_END_ID  = interface->set_signal_out <Tcontext_t        > ("front_end_id"  ,_param->_size_front_end_id     );
      if (_param->_have_port_ooo_engine_id)    
      out_MEMORY_OUT_OOO_ENGINE_ID = interface->set_signal_out <Tcontext_t        > ("ooo_engine_id" ,_param->_size_ooo_engine_id    );
      if (_param->_have_port_packet_id)       
      out_MEMORY_OUT_PACKET_ID     = interface->set_signal_out <Tpacket_t         > ("packet_id"     ,_param->_size_packet_id        );
      out_MEMORY_OUT_WRITE_RD      = interface->set_signal_out <Tcontrol_t        > ("write_rd"      ,1                              );
      out_MEMORY_OUT_NUM_REG_RD    = interface->set_signal_out <Tgeneral_address_t> ("num_reg_rd"    ,_param->_size_general_register );
      out_MEMORY_OUT_DATA_RD       = interface->set_signal_out <Tgeneral_data_t   > ("data_rd"       ,_param->_size_general_data     );
//    out_MEMORY_OUT_WRITE_RE      = interface->set_signal_out <Tcontrol_t        > ("write_rd"      ,1                              );
//    out_MEMORY_OUT_NUM_REG_RE    = interface->set_signal_out <Tspecial_address_t> ("num_reg_re"    ,_param->_size_general_register );
//    out_MEMORY_OUT_DATA_RE       = interface->set_signal_out <Tspecial_data_t   > ("data_re"       ,_param->_size_general_data     );
      out_MEMORY_OUT_EXCEPTION     = interface->set_signal_out <Texception_t      > ("exception"     ,_param->_size_exception        );
    }

    // ~~~~~[Interface "dcache_req"]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface("dcache_req"
#ifdef POSITION
							      ,OUT
							      ,NORTH
							      ,"Request port to dcache"
#endif
							      );

      out_DCACHE_REQ_VAL        = interface->set_signal_valack_out(VAL);
       in_DCACHE_REQ_ACK        = interface->set_signal_valack_in (ACK);
       if (_param->_have_port_dcache_context_id)
      out_DCACHE_REQ_CONTEXT_ID = interface->set_signal_out <Tcontext_t        > ("context_id",_param->_size_dcache_context_id  );
      out_DCACHE_REQ_PACKET_ID  = interface->set_signal_out <Tpacket_t         > ("packet_id" ,_param->_size_dcache_packet_id   );
      out_DCACHE_REQ_ADDRESS    = interface->set_signal_out <Tdcache_address_t > ("address"   ,_param->_size_general_data);
      out_DCACHE_REQ_TYPE       = interface->set_signal_out <Tdcache_type_t    > ("type"      ,_param->_size_dcache_type );
      out_DCACHE_REQ_WDATA      = interface->set_signal_out <Tdcache_data_t    > ("wdata"     ,_param->_size_general_data);
    }
    // ~~~~~[Interface "dcache_rsp"]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface("dcache_rsp"
#ifdef POSITION
							      ,IN
							      ,NORTH
							      ,"Respons port from dcache"
#endif
							      );

       in_DCACHE_RSP_VAL        = interface->set_signal_valack_in (VAL);
      out_DCACHE_RSP_ACK        = interface->set_signal_valack_out(ACK);
       if (_param->_have_port_dcache_context_id)
       in_DCACHE_RSP_CONTEXT_ID = interface->set_signal_in  <Tcontext_t     > ("context_id",_param->_size_dcache_context_id  );
       in_DCACHE_RSP_PACKET_ID  = interface->set_signal_in  <Tpacket_t      > ("packet_id" ,_param->_size_dcache_packet_id   );
       in_DCACHE_RSP_RDATA      = interface->set_signal_in  <Tdcache_data_t > ("rdata"     ,_param->_size_general_data);
       in_DCACHE_RSP_ERROR      = interface->set_signal_in  <Tdcache_error_t> ("error"     ,_param->_size_dcache_error);
    }
    // ~~~~~[Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    if (_param->_speculative_load == SPECULATIVE_LOAD_BYPASS)
      {
	out_BYPASS_MEMORY_VAL          = new SC_OUT(Tcontrol_t        ) * [_param->_size_load_queue];
	if (_param->_have_port_ooo_engine_id)    
	out_BYPASS_MEMORY_OOO_ENGINE_ID= new SC_OUT(Tcontext_t        ) * [_param->_size_load_queue];
	out_BYPASS_MEMORY_NUM_REG      = new SC_OUT(Tgeneral_address_t) * [_param->_size_load_queue];
	out_BYPASS_MEMORY_DATA         = new SC_OUT(Tgeneral_data_t   ) * [_param->_size_load_queue];
	
	for (uint32_t i=0; i<_param->_size_load_queue; i++)
	  {
	    Interface_fifo * interface = _interfaces->set_interface("memory_out"
#ifdef POSITION
								    ,OUT
								    ,NORTH
								    ,"Bypass between the load queue and the reservation station"
#endif
								    );
	    
	    out_BYPASS_MEMORY_VAL           [i] = interface->set_signal_valack_out(VAL);
	    if (_param->_have_port_ooo_engine_id)
	    out_BYPASS_MEMORY_OOO_ENGINE_ID [i] = interface->set_signal_out <Tcontext_t        > ("ooo_engine_id", _param->_size_ooo_engine_id);
	    out_BYPASS_MEMORY_NUM_REG       [i] = interface->set_signal_out <Tgeneral_address_t> ("num_reg"      , _param->_size_general_register);
	    out_BYPASS_MEMORY_DATA          [i] = interface->set_signal_out <Tgeneral_data_t   > ("data"         , _param->_size_general_data);
	  }
      }
    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    _store_queue                      = new Tstore_queue_entry_t              [_param->_size_store_queue];
    _load_queue	                      = new Tload_queue_entry_t               [_param->_size_load_queue];
    _speculative_access_queue         = new Tspeculative_access_queue_entry_t [_param->_size_speculative_access_queue];
    _speculative_access_queue_control = new morpheo::behavioural::generic::queue_control::Queue_Control (_param->_size_speculative_access_queue);

    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
