#ifdef STATISTICS
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  void RegisterFile_Monolithic::statistics_declaration (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    _stat = new Stat (static_cast<std::string>(_name),
		      "RegisterFile_Monolithic",
		      param_statistics);

    _stat_nb_read           = _stat->create_variable("nb_read" );
    _stat_nb_write          = _stat->create_variable("nb_write");
    
    _stat_average_read      = _stat->create_counter("average_read" , "", "Average read by cycle");
    _stat_average_write     = _stat->create_counter("average_write", "", "Average write by cycle");

    _stat_percent_use_read  = _stat->create_counter("percent_use_read" , "%", "Read port usage");
    _stat_percent_use_write = _stat->create_counter("percent_use_write", "%", "Write port usage");

    _stat->create_expr("average_read" , "/ nb_read  cycle", false);
    _stat->create_expr("average_write", "/ nb_write cycle", false);

    _stat->create_expr("percent_use_read" , "/ * average_read  100 " + toString(_param->_nb_port_read +_param->_nb_port_read_write), false);
    _stat->create_expr("percent_use_write", "/ * average_write 100 " + toString(_param->_nb_port_write+_param->_nb_port_read_write), false);

  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
