#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_read_queue_Read_queue_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_read_queue_Read_queue_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include <queue>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {
  
  class Tread_queue_entry_t
  {
  public    : Tcontext_t         _context_id   ;
  public    : Tcontext_t         _front_end_id ;
  public    : Tcontext_t         _ooo_engine_id;
  public    : Tpacket_t          _rob_id       ;
  public    : Toperation_t       _operation    ;
  public    : Ttype_t            _type         ;
  public    : Tcontrol_t         _has_immediat ;
  public    : Tgeneral_data_t    _immediat     ;
  public    : Tcontrol_t         _read_ra      ;
  public    : Tgeneral_address_t _num_reg_ra   ;
  public    : Tcontrol_t         _read_rb      ;
  public    : Tgeneral_address_t _num_reg_rb   ;
  public    : Tcontrol_t         _read_rc      ;
  public    : Tspecial_address_t _num_reg_rc   ;
  public    : Tcontrol_t         _write_rd     ;
  public    : Tgeneral_address_t _num_reg_rd   ;
  public    : Tcontrol_t         _write_re     ;
  public    : Tspecial_address_t _num_reg_re   ;

    friend std::ostream& operator<< (std::ostream& output_stream,
				morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue::Tread_queue_entry_t & x)
    {
      output_stream << " * _context_id    : " << toString(x._context_id   ) << std::endl
		    << " * _front_end_id  : " << toString(x._front_end_id ) << std::endl
		    << " * _ooo_engine_id : " << toString(x._ooo_engine_id) << std::endl
		    << " * _rob_id        : " << toString(x._rob_id       ) << std::endl
		    << " * _operation     : " << toString(x._operation    ) << std::endl
		    << " * _type          : " << toString(x._type         ) << std::endl
		    << " * _has_immediat  : " << toString(x._has_immediat ) << std::endl
		    << " * _immediat      : " << toString(x._immediat     ) << std::endl
		    << " * _read_ra       : " << toString(x._read_ra      ) << std::endl
		    << " * _num_reg_ra    : " << toString(x._num_reg_ra   ) << std::endl
		    << " * _read_rb       : " << toString(x._read_rb      ) << std::endl
		    << " * _num_reg_rb    : " << toString(x._num_reg_rb   ) << std::endl
		    << " * _read_rc       : " << toString(x._read_rc      ) << std::endl
		    << " * _num_reg_rc    : " << toString(x._num_reg_rc   ) << std::endl
		    << " * _write_rd      : " << toString(x._write_rd     ) << std::endl
		    << " * _num_reg_rd    : " << toString(x._num_reg_rd   ) << std::endl
		    << " * _write_re      : " << toString(x._write_re     ) << std::endl
		    << " * _num_reg_re    : " << toString(x._num_reg_re   ) << std::endl;

      return output_stream;
    }

  };

  class Tread_queue_head_entry_t
  {
  public    : Tcontext_t         _context_id   ;
  public    : Tcontext_t         _front_end_id ;
  public    : Tcontext_t         _ooo_engine_id;
  public    : Tpacket_t          _rob_id       ;
  public    : Toperation_t       _operation    ;
  public    : Ttype_t            _type         ;
  public    : Tcontrol_t         _has_immediat ;
  public    : Tgeneral_data_t    _immediat     ;
  public    : Tcontrol_t         _read_ra      ;
  public    : Tcontrol_t         _read_ra_val  ; // 1 : must access at the registerFile (after access, is set at 0)
  public    : Tgeneral_address_t _num_reg_ra   ;
  public    : Tcontrol_t         _data_ra_val  ; // 1 : the read of registerFile is valid
  public    : Tgeneral_data_t    _data_ra      ;
  public    : Tcontrol_t         _read_rb      ;
  public    : Tcontrol_t         _read_rb_val  ;
  public    : Tgeneral_address_t _num_reg_rb   ;
  public    : Tcontrol_t         _data_rb_val  ;
  public    : Tgeneral_data_t    _data_rb      ;
  public    : Tcontrol_t         _read_rc      ;
  public    : Tcontrol_t         _read_rc_val  ;
  public    : Tspecial_address_t _num_reg_rc   ;
  public    : Tcontrol_t         _data_rc_val  ;
  public    : Tspecial_data_t    _data_rc      ;
  public    : Tcontrol_t         _write_rd     ;
  public    : Tgeneral_address_t _num_reg_rd   ;
  public    : Tcontrol_t         _write_re     ;
  public    : Tspecial_address_t _num_reg_re   ;

#undef  FUNCTION 
#define FUNCTION "Tread_queue_head_entry_t::operator="
  public    : Tread_queue_head_entry_t& operator=(Tread_queue_entry_t x)
    {
      log_printf(FUNC,Read_queue,FUNCTION,"Begin");
	  
      _context_id   = x._context_id   ;
      _front_end_id = x._front_end_id ;
      _ooo_engine_id= x._ooo_engine_id;
      _rob_id       = x._rob_id       ;
      _operation    = x._operation    ;
      _type         = x._type         ;
      _has_immediat = x._has_immediat ;
      _immediat     = x._immediat     ;
      _read_ra      = x._read_ra      ;
      _read_ra_val  = x._read_ra == 1 ; //if not must read, the registerFile is already access
      _num_reg_ra   = x._num_reg_ra   ;
      _data_ra_val  = x._read_ra == 0 ; //if not must read, the data is already valid
      _data_ra      = 0               ;
      _read_rb      = x._read_rb      ;
      _read_rb_val  = x._read_rb == 1 ;
      _num_reg_rb   = x._num_reg_rb   ;
      _data_rb_val  = x._read_rb == 0 ;
      _data_rb      = 0               ;
      _read_rc      = x._read_rc      ;
      _read_rc_val  = x._read_rc == 1 ;
      _num_reg_rc   = x._num_reg_rc   ;
      _data_rc_val  = x._read_rc == 0 ;
      _data_rc      = 0               ;
      _write_rd     = x._write_rd     ;
      _num_reg_rd   = x._num_reg_rd   ;
      _write_re     = x._write_re     ;
      _num_reg_re   = x._num_reg_re   ;

      log_printf(FUNC,Read_queue,FUNCTION,"End");

      return *this;
    }

    friend std::ostream& operator<< (std::ostream& output_stream,
				morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue::Tread_queue_head_entry_t & x)
    {
      output_stream << " * _context_id    : " << x._context_id   << std::endl
		    << " * _front_end_id  : " << x._front_end_id << std::endl
		    << " * _ooo_engine_id : " << x._ooo_engine_id<< std::endl
		    << " * _rob_id        : " << x._rob_id       << std::endl
		    << " * _operation     : " << x._operation    << std::endl
		    << " * _type          : " << x._type         << std::endl
		    << " * _has_immediat  : " << x._has_immediat << std::endl
		    << " * _immediat      : " << x._immediat     << std::endl
		    << " * _read_ra       : " << x._read_ra      << std::endl
		    << " * _read_ra_val   : " << x._read_ra_val  << std::endl 
		    << " * _num_reg_ra    : " << x._num_reg_ra   << std::endl
		    << " * _data_ra_val   : " << x._data_ra_val  << std::endl
		    << " * _data_ra       : " << x._data_ra      << std::endl
		    << " * _read_rb       : " << x._read_rb      << std::endl
		    << " * _read_rb_val   : " << x._read_rb_val  << std::endl
		    << " * _num_reg_rb    : " << x._num_reg_rb   << std::endl
		    << " * _data_rb_val   : " << x._data_rb_val  << std::endl
		    << " * _data_rb       : " << x._data_rb      << std::endl
		    << " * _read_rc       : " << x._read_rc      << std::endl
		    << " * _read_rc_val   : " << x._read_rc_val  << std::endl
		    << " * _num_reg_rc    : " << x._num_reg_rc   << std::endl
		    << " * _data_rc_val   : " << x._data_rc_val  << std::endl
		    << " * _data_rc       : " << x._data_rc      << std::endl
		    << " * _write_rd      : " << x._write_rd     << std::endl
		    << " * _num_reg_rd    : " << x._num_reg_rd   << std::endl
		    << " * _write_re      : " << x._write_re     << std::endl
		    << " * _num_reg_re    : " << x._num_reg_re   << std::endl;

      return output_stream;
    }
  };

  class Read_queue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const std::string                _name;
  protected : const Parameters               * _param;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK               ;
  public    : SC_IN (Tcontrol_t        )    *  in_NRESET              ;

    // ~~~~~[Interface "read_queue_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_VAL          ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_IN_ACK          ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_QUEUE_IN_CONTEXT_ID   ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_QUEUE_IN_FRONT_END_ID ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_QUEUE_IN_OOO_ENGINE_ID;
  public    : SC_IN (Tpacket_t         )    *  in_READ_QUEUE_IN_ROB_ID       ;
  public    : SC_IN (Toperation_t      )    *  in_READ_QUEUE_IN_OPERATION    ;
  public    : SC_IN (Ttype_t           )    *  in_READ_QUEUE_IN_TYPE         ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_HAS_IMMEDIAT ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_READ_QUEUE_IN_IMMEDIAT     ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_READ_RA      ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RA   ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_READ_RB      ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RB   ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_READ_RC      ;
  public    : SC_IN (Tspecial_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RC   ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_WRITE_RD     ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RD   ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_WRITE_RE     ;
  public    : SC_IN (Tspecial_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RE   ;

    // ~~~~~[Interface "read_queue_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_VAL         ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_OUT_ACK         ;
  public    : SC_OUT(Tcontext_t        )    * out_READ_QUEUE_OUT_CONTEXT_ID   ;
  public    : SC_OUT(Tcontext_t        )    * out_READ_QUEUE_OUT_FRONT_END_ID ;
  public    : SC_OUT(Tcontext_t        )    * out_READ_QUEUE_OUT_OOO_ENGINE_ID;
  public    : SC_OUT(Tpacket_t         )    * out_READ_QUEUE_OUT_ROB_ID       ;
  public    : SC_OUT(Toperation_t      )    * out_READ_QUEUE_OUT_OPERATION   ;
  public    : SC_OUT(Ttype_t           )    * out_READ_QUEUE_OUT_TYPE        ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_HAS_IMMEDIAT;
  public    : SC_OUT(Tgeneral_data_t   )    * out_READ_QUEUE_OUT_IMMEDIAT    ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_READ_RA     ;
  public    : SC_OUT(Tgeneral_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RA  ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_DATA_RA_VAL ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_READ_QUEUE_OUT_DATA_RA     ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_READ_RB     ;
  public    : SC_OUT(Tgeneral_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RB  ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_DATA_RB_VAL ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_READ_QUEUE_OUT_DATA_RB     ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_READ_RC     ;
  public    : SC_OUT(Tspecial_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RC  ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_DATA_RC_VAL ;
  public    : SC_OUT(Tspecial_data_t   )    * out_READ_QUEUE_OUT_DATA_RC     ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_WRITE_RD    ;
  public    : SC_OUT(Tgeneral_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RD  ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_WRITE_RE    ;
  public    : SC_OUT(Tspecial_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RE  ;

    // ~~~~~[Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_READ_VAL          ;
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_READ_ACK          ;
  public    : SC_OUT(Tcontext_t        )   ** out_GPR_READ_OOO_ENGINE_ID;
  public    : SC_OUT(Tgeneral_address_t)   ** out_GPR_READ_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_READ_DATA         ;
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_READ_DATA_VAL     ;

    // ~~~~~[Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_READ_VAL          ;
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_READ_ACK          ;
  public    : SC_OUT(Tcontext_t        )   ** out_SPR_READ_OOO_ENGINE_ID;
  public    : SC_OUT(Tspecial_address_t)   ** out_SPR_READ_NUM_REG      ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_READ_DATA         ;
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_READ_DATA_VAL     ;

    // ~~~~~[Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_VAL          ;
  public    : SC_IN (Tcontext_t        )   **  in_GPR_WRITE_OOO_ENGINE_ID;
  public    : SC_IN (Tgeneral_address_t)   **  in_GPR_WRITE_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_WRITE_DATA         ;

    // ~~~~~[Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_VAL          ;
  public    : SC_IN (Tcontext_t        )   **  in_SPR_WRITE_OOO_ENGINE_ID;
  public    : SC_IN (Tspecial_address_t)   **  in_SPR_WRITE_NUM_REG      ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_WRITE_DATA         ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : Tread_queue_head_entry_t       * _queue_head;
  protected : std::queue<Tread_queue_entry_t *>   * _queue;

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_VAL         ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_READ_RA_VAL ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_READ_RB_VAL ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_READ_RC_VAL ;

  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_DATA_RA_VAL ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_DATA_RB_VAL ;
  protected  :Tgeneral_data_t                  internal_READ_QUEUE_OUT_DATA_RA     ;
  protected  :Tgeneral_data_t                  internal_READ_QUEUE_OUT_DATA_RB     ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_DATA_RC_VAL ;
  protected  :Tspecial_data_t                  internal_READ_QUEUE_OUT_DATA_RC     ;
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Read_queue);
#endif
  public  :          Read_queue              (
#ifdef SYSTEMC
					      sc_module_name                              name,
#else					       
					      std::string                                 name,
#endif					       
#ifdef STATISTICS
					      morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
					      Parameters                                  * param );
					       
  public  :          Read_queue              (Parameters * param );
  public  :          ~Read_queue             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                  (void);
  private : void     deallocation                (void);
					       
  public  : void     transition                  (void);
  public  : void     genMoore                    (void);
  public  : void     genMealy_read_queue_out_val (void); 
  public  : void     genMealy_read_queue_out_gpr (void);
  public  : void     genMealy_read_queue_out_spr (void);
#endif					       
#ifdef STATISTICS
  public  : void     statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
			
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
