#ifndef morpheo_behavioural_Configuration_Parameters_h
#define morpheo_behavioural_Configuration_Parameters_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include "Behavioural/include/XML.h"
#include "Behavioural/include/Environnement.h"
#include "Common/include/ErrorMorpheo.h"
#include "Common/include/ToString.h"

namespace morpheo     {
namespace behavioural {

  class Configuration_Parameters
  {
    // -----[fields ]----------------------------------------------------
    // Constant
  public   : const std::string    _name   ;
  public   : const uint32_t  _value  ;
  public   : const uint32_t  _min    ;
  public   : const uint32_t  _max    ;
  public   : const std::string    _step   ;
  public   : const uint32_t  _default;
  public   : const uint32_t  _level  ;
  public   : const std::string    _comment;

    // -----[methods ]---------------------------------------------------
  public   :                 Configuration_Parameters  (std::string   name   ,
							uint32_t value  ,
							uint32_t min    ,
							uint32_t max    ,
							std::string   step   ,
							uint32_t value_default,
							uint32_t level  ,
							std::string   comment);
  public   :                 ~Configuration_Parameters ();

    // methods to print and test parameters_configuration
  public   : std::string          print                      (uint32_t depth);
  public   : friend std::ostream& operator<<                 (std::ostream& output_stream,
							      morpheo::behavioural::Configuration_Parameters & x);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
