/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/SelfTest/include/test.h"

#define NB_PARAMS 18

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - size_queue          (unsigned int)" << endl
       << " - nb_inst_retire      (unsigned int)" << endl
       << " - nb_context          (unsigned int)" << endl
       << " - nb_front_end        (unsigned int)" << endl
       << " - nb_ooo_engine       (unsigned int)" << endl
       << " - nb_packet           (unsigned int)" << endl
       << " - size_general_data   (unsigned int)" << endl
       << " - size_special_data   (unsigned int)" << endl
       << " - nb_general_register (unsigned int)" << endl
       << " - nb_special_register (unsigned int)" << endl
       << " - nb_operation        (unsigned int)" << endl
       << " - nb_type             (unsigned int)" << endl
       << " - nb_gpr_write        (unsigned int)" << endl
       << " - nb_spr_write        (unsigned int)" << endl
       << " - nb_bypass_write     (unsigned int)" << endl
       << " - nb_bypass_memory    (unsigned int)" << endl
       << " - size_store_queue    (unsigned int)" << endl
       << " - size_load_queue     (unsigned int)" << endl
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t x=1;
  const string   name                =      argv[x++];
  const uint32_t size_queue          = atoi(argv[x++]);
  const uint32_t nb_inst_retire      = atoi(argv[x++]);
  const uint32_t nb_context          = atoi(argv[x++]);
  const uint32_t nb_front_end        = atoi(argv[x++]);
  const uint32_t nb_ooo_engine       = atoi(argv[x++]);
  const uint32_t nb_packet           = atoi(argv[x++]);
  const uint32_t size_general_data   = atoi(argv[x++]);
  const uint32_t size_special_data   = atoi(argv[x++]);
  const uint32_t nb_general_register = atoi(argv[x++]);
  const uint32_t nb_special_register = atoi(argv[x++]);
  const uint32_t nb_operation        = atoi(argv[x++]);
  const uint32_t nb_type             = atoi(argv[x++]);
  const uint32_t nb_gpr_write        = atoi(argv[x++]);
  const uint32_t nb_spr_write        = atoi(argv[x++]);
  const uint32_t nb_bypass_write     = atoi(argv[x++]);
  const uint32_t nb_bypass_memory    = atoi(argv[x++]);
  const uint32_t size_store_queue    = atoi(argv[x++]);
  const uint32_t size_load_queue     = atoi(argv[x++]);
  
  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Parameters
	(size_queue    
	 ,nb_inst_retire     
	 ,nb_context         
	 ,nb_front_end       
	 ,nb_ooo_engine
	 ,nb_packet          
	 ,size_general_data  
	 ,size_special_data  
	 ,nb_general_register
	 ,nb_special_register
	 ,nb_operation       
	 ,nb_type            
	 ,nb_gpr_write
	 ,nb_spr_write
	 ,nb_bypass_write 
	 ,nb_bypass_memory
	 ,size_store_queue
	 ,size_load_queue 
	 );
      
      cout << param->print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

