/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/SelfTest/include/test.h"

#define NB_PARAMS 19

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * size_read_queue          (uint32_t)\n"));
  err (_(" * size_reservation_station (uint32_t)\n"));
  err (_(" * nb_context               (uint32_t)\n"));
  err (_(" * nb_front_end             (uint32_t)\n"));
  err (_(" * nb_ooo_engine            (uint32_t)\n"));
  err (_(" * nb_packet                (uint32_t)\n"));
  err (_(" * size_general_data        (uint32_t)\n"));
  err (_(" * size_special_data        (uint32_t)\n"));
  err (_(" * nb_general_register      (uint32_t)\n"));
  err (_(" * nb_special_register      (uint32_t)\n"));
  err (_(" * nb_operation             (uint32_t)\n"));
  err (_(" * nb_type                  (uint32_t)\n"));
  err (_(" * nb_gpr_write             (uint32_t)\n"));
  err (_(" * nb_spr_write             (uint32_t)\n"));
  err (_(" * size_store_queue         (uint32_t)\n"));
  err (_(" * size_load_queue          (uint32_t)\n"));
  err (_(" * nb_inst_retire           (uint32_t)\n"));
  err (_(" * nb_bypass_write          (uint32_t)\n"));
  err (_(" * nb_bypass_memory         (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;

  const string   name      =      argv[x++];
  const uint32_t    _size_read_queue          = atoi(argv[x++]);
  const uint32_t    _size_reservation_station = atoi(argv[x++]);
  const uint32_t    _nb_context               = atoi(argv[x++]);
  const uint32_t    _nb_front_end             = atoi(argv[x++]);
  const uint32_t    _nb_ooo_engine            = atoi(argv[x++]);
  const uint32_t    _nb_packet                = atoi(argv[x++]);
  const uint32_t    _size_general_data        = atoi(argv[x++]);
  const uint32_t    _size_special_data        = atoi(argv[x++]);
  const uint32_t    _nb_general_register      = atoi(argv[x++]);
  const uint32_t    _nb_special_register      = atoi(argv[x++]);
  const uint32_t    _nb_operation             = atoi(argv[x++]);
  const uint32_t    _nb_type                  = atoi(argv[x++]);
  const uint32_t    _nb_gpr_write             = atoi(argv[x++]);
  const uint32_t    _nb_spr_write             = atoi(argv[x++]);
  const uint32_t    _size_store_queue         = atoi(argv[x++]);
  const uint32_t    _size_load_queue          = atoi(argv[x++]);
  const uint32_t    _nb_inst_retire           = atoi(argv[x++]);
  const uint32_t    _nb_bypass_write          = atoi(argv[x++]);
  const uint32_t    _nb_bypass_memory         = atoi(argv[x++]);

  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Parameters
	(
	 _size_read_queue         ,
	 _size_reservation_station,
	 _nb_context              ,
	 _nb_front_end            ,
	 _nb_ooo_engine           ,
	 _nb_packet               ,
	 _size_general_data       ,
	 _size_special_data       ,
	 _nb_general_register     ,
	 _nb_special_register     ,
	 _nb_operation            ,
	 _nb_type                 ,
	 _nb_gpr_write            ,
	 _nb_spr_write            ,
	 _size_store_queue        ,
	 _size_load_queue         ,
	 _nb_inst_retire          ,
	 _nb_bypass_write         ,
	 _nb_bypass_memory        );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> : %s.\n"),name.c_str(), error.what ());
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

