/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#define LABEL(str...)							\
  {									\
    msg (_("{%d} "),static_cast<uint32_t>(sc_simulation_time()));	\
    msg (str);								\
    msg (_("\n"));							\
  } while(0)

#define SC_START(cycle_offset)                                                       \
  do									             \
    {									             \
      /*cout << "SC_START (begin)" << endl;*/				             \
									             \
      uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time());          \
      if (cycle_offset != 0)						             \
	{								             \
	  cout << "##########[ cycle "<< cycle_current+cycle_offset << " ]" << endl; \
	}								             \
									             \
      if (cycle_current > CYCLE_MAX)					             \
	{								             \
	  TEST_KO("Maximal cycles Reached");				             \
	}								             \
									             \
      sc_start(cycle_offset);						             \
									             \
      /*cout << "SC_START (end  )" << endl;*/				             \
    } while(0)

void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Read_unit * _Read_unit = new Read_unit (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_VAL                   ," in_READ_UNIT_IN_VAL                   ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_READ_UNIT_IN_ACK                   ,"out_READ_UNIT_IN_ACK                   ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_CONTEXT_ID            ," in_READ_UNIT_IN_CONTEXT_ID            ",Tcontext_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_FRONT_END_ID          ," in_READ_UNIT_IN_FRONT_END_ID          ",Tcontext_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_OOO_ENGINE_ID         ," in_READ_UNIT_IN_OOO_ENGINE_ID         ",Tcontext_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_PACKET_ID             ," in_READ_UNIT_IN_PACKET_ID             ",Tpacket_t         );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_OPERATION             ," in_READ_UNIT_IN_OPERATION             ",Toperation_t      );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_TYPE                  ," in_READ_UNIT_IN_TYPE                  ",Ttype_t           );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE ," in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE ",Tlsq_ptr_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE  ," in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE  ",Tlsq_ptr_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_HAS_IMMEDIAT          ," in_READ_UNIT_IN_HAS_IMMEDIAT          ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_IMMEDIAT              ," in_READ_UNIT_IN_IMMEDIAT              ",Tgeneral_data_t   );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_READ_RA               ," in_READ_UNIT_IN_READ_RA               ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_NUM_REG_RA            ," in_READ_UNIT_IN_NUM_REG_RA            ",Tgeneral_address_t);
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_READ_RB               ," in_READ_UNIT_IN_READ_RB               ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_NUM_REG_RB            ," in_READ_UNIT_IN_NUM_REG_RB            ",Tgeneral_address_t);
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_READ_RC               ," in_READ_UNIT_IN_READ_RC               ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_NUM_REG_RC            ," in_READ_UNIT_IN_NUM_REG_RC            ",Tspecial_address_t);
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_WRITE_RD              ," in_READ_UNIT_IN_WRITE_RD              ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_NUM_REG_RD            ," in_READ_UNIT_IN_NUM_REG_RD            ",Tgeneral_address_t);
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_WRITE_RE              ," in_READ_UNIT_IN_WRITE_RE              ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_READ_UNIT_IN_NUM_REG_RE            ," in_READ_UNIT_IN_NUM_REG_RE            ",Tspecial_address_t);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_VAL                  ,"out_READ_UNIT_OUT_VAL                  ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_READ_UNIT_OUT_ACK                  ," in_READ_UNIT_OUT_ACK                  ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_CONTEXT_ID           ,"out_READ_UNIT_OUT_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_FRONT_END_ID         ,"out_READ_UNIT_OUT_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_OOO_ENGINE_ID        ,"out_READ_UNIT_OUT_OOO_ENGINE_ID        ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_PACKET_ID            ,"out_READ_UNIT_OUT_PACKET_ID            ",Tpacket_t         ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_OPERATION            ,"out_READ_UNIT_OUT_OPERATION            ",Toperation_t      ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_TYPE                 ,"out_READ_UNIT_OUT_TYPE                 ",Ttype_t           ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE,"out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ,"out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_HAS_IMMEDIAT         ,"out_READ_UNIT_OUT_HAS_IMMEDIAT         ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_IMMEDIAT             ,"out_READ_UNIT_OUT_IMMEDIAT             ",Tgeneral_data_t   ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_DATA_RA              ,"out_READ_UNIT_OUT_DATA_RA              ",Tgeneral_data_t   ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_DATA_RB              ,"out_READ_UNIT_OUT_DATA_RB              ",Tgeneral_data_t   ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_DATA_RC              ,"out_READ_UNIT_OUT_DATA_RC              ",Tspecial_data_t   ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_WRITE_RD             ,"out_READ_UNIT_OUT_WRITE_RD             ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_NUM_REG_RD           ,"out_READ_UNIT_OUT_NUM_REG_RD           ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_WRITE_RE             ,"out_READ_UNIT_OUT_WRITE_RE             ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_NUM_REG_RE           ,"out_READ_UNIT_OUT_NUM_REG_RE           ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_GPR_READ_VAL                       ,"out_GPR_READ_VAL                       ",Tcontrol_t        ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL( in_GPR_READ_ACK                       ," in_GPR_READ_ACK                       ",Tcontrol_t        ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL(out_GPR_READ_OOO_ENGINE_ID             ,"out_GPR_READ_OOO_ENGINE_ID             ",Tcontext_t        ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL(out_GPR_READ_NUM_REG                   ,"out_GPR_READ_NUM_REG                   ",Tgeneral_address_t,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL( in_GPR_READ_DATA                      ," in_GPR_READ_DATA                      ",Tgeneral_data_t   ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL( in_GPR_READ_DATA_VAL                  ," in_GPR_READ_DATA_VAL                  ",Tcontrol_t        ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL(out_SPR_READ_VAL                       ,"out_SPR_READ_VAL                       ",Tcontrol_t        ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL( in_SPR_READ_ACK                       ," in_SPR_READ_ACK                       ",Tcontrol_t        ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL(out_SPR_READ_OOO_ENGINE_ID             ,"out_SPR_READ_OOO_ENGINE_ID             ",Tcontext_t        ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL(out_SPR_READ_NUM_REG                   ,"out_SPR_READ_NUM_REG                   ",Tspecial_address_t,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL( in_SPR_READ_DATA                      ," in_SPR_READ_DATA                      ",Tspecial_data_t   ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL( in_SPR_READ_DATA_VAL                  ," in_SPR_READ_DATA_VAL                  ",Tcontrol_t        ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_VAL                      ," in_GPR_WRITE_VAL                      ",Tcontrol_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_OOO_ENGINE_ID            ," in_GPR_WRITE_OOO_ENGINE_ID            ",Tcontext_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_NUM_REG                  ," in_GPR_WRITE_NUM_REG                  ",Tgeneral_address_t,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_DATA                     ," in_GPR_WRITE_DATA                     ",Tgeneral_data_t   ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_VAL                      ," in_SPR_WRITE_VAL                      ",Tcontrol_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_OOO_ENGINE_ID            ," in_SPR_WRITE_OOO_ENGINE_ID            ",Tcontext_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_NUM_REG                  ," in_SPR_WRITE_NUM_REG                  ",Tspecial_address_t,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_DATA                     ," in_SPR_WRITE_DATA                     ",Tspecial_data_t   ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_OOO_ENGINE_ID         ," in_BYPASS_WRITE_OOO_ENGINE_ID         ",Tcontext_t        ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_GPR_VAL               ," in_BYPASS_WRITE_GPR_VAL               ",Tcontrol_t        ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_GPR_NUM_REG           ," in_BYPASS_WRITE_GPR_NUM_REG           ",Tgeneral_address_t,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_GPR_DATA              ," in_BYPASS_WRITE_GPR_DATA              ",Tgeneral_data_t   ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_SPR_VAL               ," in_BYPASS_WRITE_SPR_VAL               ",Tcontrol_t        ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_SPR_NUM_REG           ," in_BYPASS_WRITE_SPR_NUM_REG           ",Tspecial_address_t,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_SPR_DATA              ," in_BYPASS_WRITE_SPR_DATA              ",Tspecial_data_t   ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_MEMORY_VAL                  ," in_BYPASS_MEMORY_VAL                  ",Tcontrol_t        ,_param->_nb_bypass_memory);
  ALLOC1_SC_SIGNAL( in_BYPASS_MEMORY_OOO_ENGINE_ID        ," in_BYPASS_MEMORY_OOO_ENGINE_ID        ",Tcontext_t        ,_param->_nb_bypass_memory);
  ALLOC1_SC_SIGNAL( in_BYPASS_MEMORY_NUM_REG              ," in_BYPASS_MEMORY_NUM_REG              ",Tgeneral_address_t,_param->_nb_bypass_memory);
  ALLOC1_SC_SIGNAL( in_BYPASS_MEMORY_DATA                 ," in_BYPASS_MEMORY_DATA                 ",Tgeneral_data_t   ,_param->_nb_bypass_memory);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Read_unit.\n"),name.c_str());

  (*(_Read_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Read_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_VAL                   );
  INSTANCE_SC_SIGNAL (_Read_unit,out_READ_UNIT_IN_ACK                   );
  if (_param->_have_port_context_id)
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_CONTEXT_ID            );
  if (_param->_have_port_front_end_id)
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_FRONT_END_ID          );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_OOO_ENGINE_ID         );
  if (_param->_have_port_packet_id)
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_PACKET_ID             );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_OPERATION             );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_TYPE                  );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE  );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_HAS_IMMEDIAT          );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_IMMEDIAT              );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_READ_RA               );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_NUM_REG_RA            );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_READ_RB               );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_NUM_REG_RB            );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_READ_RC               );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_NUM_REG_RC            );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_WRITE_RD              );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_NUM_REG_RD            );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_WRITE_RE              );
  INSTANCE_SC_SIGNAL (_Read_unit, in_READ_UNIT_IN_NUM_REG_RE            );
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_VAL                  ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_READ_UNIT_OUT_ACK                  ,_param->_nb_inst_retire);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_CONTEXT_ID           ,_param->_nb_inst_retire);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_FRONT_END_ID         ,_param->_nb_inst_retire);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_OOO_ENGINE_ID        ,_param->_nb_inst_retire);
  if (_param->_have_port_packet_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_PACKET_ID            ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_OPERATION            ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_TYPE                 ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_HAS_IMMEDIAT         ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_IMMEDIAT             ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_DATA_RA              ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_DATA_RB              ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_DATA_RC              ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_WRITE_RD             ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_NUM_REG_RD           ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_WRITE_RE             ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_NUM_REG_RE           ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_GPR_READ_VAL                       ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_READ_ACK                       ,_param->_nb_gpr_read);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_GPR_READ_OOO_ENGINE_ID             ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_GPR_READ_NUM_REG                   ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_READ_DATA                      ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_READ_DATA_VAL                  ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_SPR_READ_VAL                       ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_READ_ACK                       ,_param->_nb_spr_read);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_SPR_READ_OOO_ENGINE_ID             ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_SPR_READ_NUM_REG                   ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_READ_DATA                      ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_READ_DATA_VAL                  ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_WRITE_VAL                      ,_param->_nb_gpr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_WRITE_OOO_ENGINE_ID            ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_WRITE_NUM_REG                  ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_WRITE_DATA                     ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_WRITE_VAL                      ,_param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_WRITE_OOO_ENGINE_ID            ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_WRITE_NUM_REG                  ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_WRITE_DATA                     ,_param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_OOO_ENGINE_ID         ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_GPR_VAL               ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_GPR_NUM_REG           ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_GPR_DATA              ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_SPR_VAL               ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_SPR_NUM_REG           ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_SPR_DATA              ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_MEMORY_VAL                  ,_param->_nb_bypass_memory);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_MEMORY_OOO_ENGINE_ID        ,_param->_nb_bypass_memory);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_MEMORY_NUM_REG              ,_param->_nb_bypass_memory);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_MEMORY_DATA                 ,_param->_nb_bypass_memory);
  
  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;
#endif

  delete _Read_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
