/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


#undef  FUNCTION
#define FUNCTION "Functionnal_unit::Parameters"
  Parameters::Parameters (uint32_t           nb_context         ,
			  uint32_t           nb_front_end       ,
			  uint32_t           nb_ooo_engine      ,
			  uint32_t           nb_packet          ,
			  uint32_t           size_general_data  ,
			  uint32_t           nb_general_register,
			  uint32_t           size_special_data  ,
			  uint32_t           nb_special_register,
			  uint32_t           nb_operation       ,
			  uint32_t           nb_type            ,
			  execute_timing_t** timing             ,
			  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (uint32_t)) :
    _nb_context              (nb_context            ),
    _nb_front_end            (nb_front_end          ),
    _nb_ooo_engine           (nb_ooo_engine         ),
    _nb_packet               (nb_packet             ),
    _size_general_data       (size_general_data     ),
    _nb_general_register     (nb_general_register   ),
    _size_special_data       (size_special_data     ),
    _nb_special_register     (nb_special_register   ),
    _nb_operation            (nb_operation          ),
    _nb_type                 (nb_type               ),
    
    _size_context_id         (log2(nb_context      )),
    _size_front_end_id       (log2(nb_front_end    )),
    _size_ooo_engine_id      (log2(nb_ooo_engine   )),
    _size_packet_id          (log2(nb_packet       )),
    _size_general_register   (log2(_size_general_register)),
    _size_special_register   (log2(_size_special_register)),
    _size_operation          (log2(_size_operation       )),
    _size_type               (log2(_size_type            )),

    _have_port_context_id    (_size_context_id    > 0),
    _have_port_front_end_id  (_size_front_end_id  > 0),
    _have_port_ooo_engine_id (_size_ooo_engine_id > 0),
    _have_port_packet_id     (_size_packet_id     > 0),

    _have_groupe_MAC         ( (timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MAC  ]._latence > 0) or
			       (timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MACRC]._latence > 0) or
			       (timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MSB  ]._latence > 0))
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    _timing                 = timing;
    _get_custom_information = get_custom_information;

    test();

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Functionnal_unit::Parameters (copy)"
  Parameters::Parameters (Parameters & param):
    _nb_context              (param._nb_context             ),
    _nb_front_end            (param._nb_front_end           ),
    _nb_ooo_engine           (param._nb_ooo_engine          ),
    _nb_packet               (param._nb_packet              ),
    _size_general_data       (param._size_general_data      ),
    _nb_general_register     (param._nb_general_register    ),
    _size_special_data       (param._size_special_data      ),
    _nb_special_register     (param._nb_special_register    ),
    _nb_operation            (param._nb_operation           ),
    _nb_type                 (param._nb_type                ),

    _size_context_id         (param._size_context_id        ),
    _size_front_end_id       (param._size_front_end_id      ),
    _size_ooo_engine_id      (param._size_ooo_engine_id     ),
    _size_packet_id          (param._size_packet_id         ),
    _size_general_register   (param._size_general_register  ),
    _size_special_register   (param._size_special_register  ),
    _size_operation          (param._size_operation         ),
    _size_type               (param._size_type              ),

    _have_port_context_id    (param._have_port_context_id   ),
    _have_port_front_end_id  (param._have_port_front_end_id ),
    _have_port_ooo_engine_id (param._have_port_ooo_engine_id),
    _have_port_packet_id     (param._have_port_packet_id    ),

    _have_groupe_MAC         (param._have_groupe_MAC        )
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    _timing                 = param._timing;
    _get_custom_information = param._get_custom_information;

    test();
    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Functionnal_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");
    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
