#ifndef Allocation_H
#define Allocation_H

// Help to allocate interface

// ----------------------------------------------------------------------
// -----[ NO ITERATION ]-------------------------------------------------
// ----------------------------------------------------------------------

#ifdef POSITION
#define ALLOC_INTERFACE( name, direction, localisation, str)		\
  Interface_fifo * interface = _interfaces->set_interface( name, direction, localisation, str);
#else
#define ALLOC_INTERFACE( name, direction, localisation, str)		\
  Interface_fifo * interface = _interfaces->set_interface( name);
#endif

#define ALLOC_VALACK_IN(  sig, name, type)				\
  {									\
    sig = interface->set_signal_valack_in (name, type);			\
  }									
#define ALLOC_VALACK_OUT( sig, name, type)				\
  {									\
    sig = interface->set_signal_valack_out(name, type);			\
  }									
#define ALLOC_VAL_IN(     sig)						\
  {									\
    sig = interface->set_signal_valack_in (VAL);			\
  }									
#define ALLOC_VAL_OUT(    sig)						\
  {									\
    sig = interface->set_signal_valack_out(VAL);			\
  }									
#define ALLOC_ACK_IN(     sig)						\
  {									\
    sig = interface->set_signal_valack_in (ACK);			\
  }									
#define ALLOC_ACK_OUT(    sig)						\
  {									\
    sig = interface->set_signal_valack_out(ACK);			\
  }									
#define ALLOC_SIGNAL_IN(  sig, name, type, size)			\
  if (size > 0)								\
    {									\
      sig = interface->set_signal_in <type> (name, size);		\
    }									
#define ALLOC_SIGNAL_OUT( sig, name, type, size)			\
  if (size > 0)								\
    {									\
      sig = interface->set_signal_out<type> (name, size);		\
    }

#define ALLOC_SC_SIGNAL(  sig, name, type)		                \
  sc_signal<type> * sig = new sc_signal<type> (name);

#define INSTANCE_SC_SIGNAL(component, sig)	\
  (*(component->sig)) (*(sig));

// ----------------------------------------------------------------------
// -----[ ITERATION 1 ]--------------------------------------------------
// ----------------------------------------------------------------------

#ifdef POSITION
#define ALLOC1_INTERFACE( name, direction, localisation, str, it1)	\
  const uint32_t iterator_1 = it1;					\
  Interface_fifo * interface [iterator_1];				\
  {									\
    std::string      separator="_";					\
    for (uint32_t i=0; i<iterator_1; i++)				\
      {									\
	interface [i] = _interfaces->set_interface( name+separator+toString(i), direction, localisation, str); \
      }									\
  }
#else
#define ALLOC1_INTERFACE( name, direction, localisation, str, it1)	\
  const uint32_t iterator_1 = it1;					\
  Interface_fifo * interface [iterator_1];				\
  {									\
    std::string      separator="_";					\
    for (uint32_t i=0; i<iterator_1; i++)				\
      {									\
	interface [i] = _interfaces->set_interface( name+separator+toString(i)); \
      }									\
  }
#endif


#define ALLOC1_VALACK_IN( sig, name, type)				\
  {									\
    sig = new SC_IN (Tcontrol_t) * [iterator_1];			\
    for (uint32_t i=0; i<iterator_1; i++)				\
      {									\
	sig [i] = interface[i]->set_signal_valack_in (name, type);	\
      }									\
  }
#define ALLOC1_VALACK_OUT(sig, name, type)				\
  {									\
    sig = new SC_OUT(Tcontrol_t) * [iterator_1];			\
    for (uint32_t i=0; i<iterator_1; i++)				\
      {									\
	sig [i] = interface[i]->set_signal_valack_out(name, type);	\
      }									\
  }
#define ALLOC1_VAL_IN(    sig)						\
  {									\
    sig = new SC_IN (Tcontrol_t) * [iterator_1];			\
    for (uint32_t i=0; i<iterator_1; i++)				\
      {									\
	sig [i] = interface[i]->set_signal_valack_in (VAL);		\
      }									\
  }
#define ALLOC1_VAL_OUT(   sig)						\
  {									\
    sig = new SC_OUT(Tcontrol_t) * [iterator_1];			\
    for (uint32_t i=0; i<iterator_1; i++)				\
      {									\
	sig [i] = interface[i]->set_signal_valack_out(VAL);		\
      }									\
  }
#define ALLOC1_ACK_IN(    sig)						\
  {									\
    sig = new SC_IN (Tcontrol_t) * [iterator_1];			\
    for (uint32_t i=0; i<iterator_1; i++)				\
      {									\
	sig [i] = interface[i]->set_signal_valack_in (ACK);		\
      }									\
  }
#define ALLOC1_ACK_OUT(   sig)						\
  {									\
    sig = new SC_OUT(Tcontrol_t) * [iterator_1];			\
    for (uint32_t i=0; i<iterator_1; i++)				\
      {									\
	sig [i] = interface[i]->set_signal_valack_out(ACK);		\
      }									\
  }
#define ALLOC1_SIGNAL_IN( sig, name, type, size)			\
  if (size > 0)								\
    {									\
      sig = new SC_IN (type) * [iterator_1];				\
      for (uint32_t i=0; i<iterator_1; i++)				\
	{								\
	  sig [i] = interface[i]->set_signal_in <type> (name, size);	\
	}								\
    }

#define ALLOC1_SIGNAL_OUT(sig, name, type, size)			\
  if (size > 0)								\
    {									\
      sig = new SC_OUT(type) * [iterator_1];				\
      for (uint32_t i=0; i<iterator_1; i++)				\
	{								\
	  sig [i] = interface[i]->set_signal_out<type> (name, size);	\
	}								\
    }

#define ALLOC1_SC_SIGNAL( sig, name, type, it1)				\
  sc_signal<type> ** sig = new sc_signal<type> * [it1];			\
  {									\
    std::string separator="_";						\
    std::string str;							\
    for (uint32_t i=0; i<it1; i++)					\
      {									\
	str = name+separator+toString(i);				\
	sig [i] = new sc_signal<type> (str.c_str());			\
      }									\
  }

#define INSTANCE1_SC_SIGNAL(component, sig, it1)	\
  for (uint32_t i=0; i<it1; i++)			\
    {							\
      (*(component->sig[i])) (*(sig[i]));		\
    }

#endif
