#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_Read_unit_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_Read_unit_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Reservation_station.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {


  class Read_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "read_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_READ_UNIT_IN_VAL                  ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_UNIT_IN_ACK                  ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_UNIT_IN_CONTEXT_ID           ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_UNIT_IN_FRONT_END_ID         ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_UNIT_IN_OOO_ENGINE_ID        ;
  public    : SC_IN (Tpacket_t         )    *  in_READ_UNIT_IN_PACKET_ID            ;
  public    : SC_IN (Toperation_t      )    *  in_READ_UNIT_IN_OPERATION            ;
  public    : SC_IN (Ttype_t           )    *  in_READ_UNIT_IN_TYPE                 ;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_UNIT_IN_HAS_IMMEDIAT         ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_READ_UNIT_IN_IMMEDIAT             ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_UNIT_IN_READ_RA              ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_UNIT_IN_NUM_REG_RA           ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_UNIT_IN_READ_RB              ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_UNIT_IN_NUM_REG_RB           ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_UNIT_IN_READ_RC              ;
  public    : SC_IN (Tspecial_address_t)    *  in_READ_UNIT_IN_NUM_REG_RC           ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_UNIT_IN_WRITE_RD             ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_UNIT_IN_NUM_REG_RD           ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_UNIT_IN_WRITE_RE             ;
  public    : SC_IN (Tspecial_address_t)    *  in_READ_UNIT_IN_NUM_REG_RE           ;

    // ~~~~~[ Interface "read_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_READ_UNIT_OUT_VAL                  ;
  public    : SC_IN (Tcontrol_t        )   **  in_READ_UNIT_OUT_ACK                  ;
  public    : SC_OUT(Tcontext_t        )   ** out_READ_UNIT_OUT_CONTEXT_ID           ;
  public    : SC_OUT(Tcontext_t        )   ** out_READ_UNIT_OUT_FRONT_END_ID         ;
  public    : SC_OUT(Tcontext_t        )   ** out_READ_UNIT_OUT_OOO_ENGINE_ID        ;
  public    : SC_OUT(Tpacket_t         )   ** out_READ_UNIT_OUT_PACKET_ID            ;
  public    : SC_OUT(Toperation_t      )   ** out_READ_UNIT_OUT_OPERATION            ;
  public    : SC_OUT(Ttype_t           )   ** out_READ_UNIT_OUT_TYPE                 ;
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE;
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ;
  public    : SC_OUT(Tcontrol_t        )   ** out_READ_UNIT_OUT_HAS_IMMEDIAT         ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_READ_UNIT_OUT_IMMEDIAT             ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_READ_UNIT_OUT_DATA_RA              ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_READ_UNIT_OUT_DATA_RB              ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_READ_UNIT_OUT_DATA_RC              ;
  public    : SC_OUT(Tcontrol_t        )   ** out_READ_UNIT_OUT_WRITE_RD             ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_READ_UNIT_OUT_NUM_REG_RD           ;
  public    : SC_OUT(Tcontrol_t        )   ** out_READ_UNIT_OUT_WRITE_RE             ;
  public    : SC_OUT(Tspecial_address_t)   ** out_READ_UNIT_OUT_NUM_REG_RE           ;

    // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_READ_VAL          ;
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_READ_ACK          ;
  public    : SC_OUT(Tcontext_t        )   ** out_GPR_READ_OOO_ENGINE_ID;
  public    : SC_OUT(Tgeneral_address_t)   ** out_GPR_READ_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_READ_DATA         ;
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_READ_DATA_VAL     ;

    // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_READ_VAL          ;
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_READ_ACK          ;
  public    : SC_OUT(Tcontext_t        )   ** out_SPR_READ_OOO_ENGINE_ID;
  public    : SC_OUT(Tspecial_address_t)   ** out_SPR_READ_NUM_REG      ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_READ_DATA         ;
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_READ_DATA_VAL     ;

    // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_VAL          ;
  public    : SC_IN (Tcontext_t        )   **  in_GPR_WRITE_OOO_ENGINE_ID;
  public    : SC_IN (Tgeneral_address_t)   **  in_GPR_WRITE_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_WRITE_DATA         ;

    // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_VAL          ;
  public    : SC_IN (Tcontext_t        )   **  in_SPR_WRITE_OOO_ENGINE_ID;
  public    : SC_IN (Tspecial_address_t)   **  in_SPR_WRITE_NUM_REG      ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_WRITE_DATA         ;

    // ~~~~~[ Interface "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontext_t        )   **  in_BYPASS_WRITE_OOO_ENGINE_ID ;
  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_WRITE_GPR_VAL       ;
  public    : SC_IN (Tgeneral_address_t)   **  in_BYPASS_WRITE_GPR_NUM_REG   ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_BYPASS_WRITE_GPR_DATA      ;
  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_WRITE_SPR_VAL       ;
  public    : SC_IN (Tspecial_address_t)   **  in_BYPASS_WRITE_SPR_NUM_REG   ;
  public    : SC_IN (Tspecial_data_t   )   **  in_BYPASS_WRITE_SPR_DATA      ;

    // ~~~~~[ Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_MEMORY_VAL          ;
  public    : SC_IN (Tcontext_t        )   **  in_BYPASS_MEMORY_OOO_ENGINE_ID;
  public    : SC_IN (Tgeneral_address_t)   **  in_BYPASS_MEMORY_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_BYPASS_MEMORY_DATA         ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

  private   : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue         ::Read_queue          * _component_read_queue;
  private   : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Reservation_station * _component_reservation_station;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Read_unit);
#endif
  public  :          Read_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Read_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
