/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/SelfTest/include/test.h"

#define NB_PARAMS 11

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_("  * nb_execute_unit                                (uint32_t)\n"));
  err (_("  * nb_write_unit                                  (uint32_t)\n"));
  err (_("  * nb_context                                     (uint32_t)\n"));
  err (_("  * nb_front_end                                   (uint32_t)\n"));
  err (_("  * nb_ooo_engine                                  (uint32_t)\n"));
  err (_("  * nb_packet                                      (uint32_t)\n"));
  err (_("  * size_general_data                              (uint32_t)\n"));
  err (_("  * size_special_data                              (uint32_t)\n"));
  err (_("  * nb_general_register                            (uint32_t)\n"));
  err (_("  * nb_special_register                            (uint32_t)\n"));
  err (_("  * priority                                       (uint32_t)\n"));
  err (_("  * table_routing [nb_execute_unit][nb_write_unit] (bool    )\n"));
  err (_("  * table_thread  [nb_write_unit][nb_thread]       (bool    )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;

  const string   name      =      argv[x++];
  uint32_t    _nb_execute_unit      = atoi(argv[x++]);
  uint32_t    _nb_write_unit        = atoi(argv[x++]);
  uint32_t    _nb_context           = atoi(argv[x++]);
  uint32_t    _nb_front_end         = atoi(argv[x++]);
  uint32_t    _nb_ooo_engine        = atoi(argv[x++]);
  uint32_t    _nb_packet            = atoi(argv[x++]);
  uint32_t    _size_general_data    = atoi(argv[x++]);
  uint32_t    _size_special_data    = atoi(argv[x++]);
  uint32_t    _nb_general_register  = atoi(argv[x++]);
  uint32_t    _nb_special_register  = atoi(argv[x++]);
  Tpriority_t _priority             = fromString<Tpriority_t>(argv[x++]);

  uint32_t    _nb_thread            = get_nb_thread(_nb_context, _nb_front_end, _nb_ooo_engine);

  if (static_cast<uint32_t>(argc) != 2+NB_PARAMS+(_nb_write_unit*_nb_execute_unit)+(_nb_write_unit*_nb_thread))
    usage (argc, argv);
  
  bool ** _table_routing;
  bool ** _table_thread ;
  
  _table_routing = new bool * [_nb_execute_unit];
  for (uint32_t i=0; i<_nb_execute_unit; i++)
    {
      _table_routing [i] = new bool [_nb_write_unit];
      for (uint32_t j=0; j<_nb_write_unit; j++)
	_table_routing [i][j] = atoi(argv[x++]);
    }

  _table_thread = new bool * [_nb_write_unit];
  for (uint32_t i=0; i<_nb_write_unit; i++)
    {
      _table_thread [i] = new bool [_nb_thread];

      for (uint32_t j=0; j<_nb_thread; j++)
	_table_thread [i][j] = atoi(argv[x++]);
    }

  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::Parameters
	(_nb_execute_unit      ,
	 _nb_write_unit        ,
	 _nb_context           ,
	 _nb_front_end         ,
	 _nb_ooo_engine        ,
	 _nb_packet            ,
	 _size_general_data    ,
	 _size_special_data    ,
	 _nb_general_register  ,
	 _nb_special_register  ,
	 _priority             ,
	 _table_routing        ,
	 _table_thread 
	 );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> : %s.\n"),name.c_str(), error.what ());
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

