/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Read_unit_to_Execution_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::Read_unit_to_Execution_unit"
  Read_unit_to_Execution_unit::Read_unit_to_Execution_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");

    log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (_usage & USE_VHDL)
      {
	// generate the vhdl
	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,"Method - genMealy");

	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();

	for (uint32_t i=0; i<_param->_nb_read_unit; i++)
	  {
	    sensitive << (*(in_READ_UNIT_OUT_VAL                   [i]))
		      << (*(in_READ_UNIT_OUT_OPERATION             [i]))
		      << (*(in_READ_UNIT_OUT_TYPE                  [i]))
		      << (*(in_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE [i]))
		      << (*(in_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE  [i]))
		      << (*(in_READ_UNIT_OUT_HAS_IMMEDIAT          [i]))
		      << (*(in_READ_UNIT_OUT_IMMEDIAT              [i]))
		      << (*(in_READ_UNIT_OUT_DATA_RA               [i]))
		      << (*(in_READ_UNIT_OUT_DATA_RB               [i]))
		      << (*(in_READ_UNIT_OUT_DATA_RC               [i]))
		      << (*(in_READ_UNIT_OUT_WRITE_RD              [i]))
		      << (*(in_READ_UNIT_OUT_NUM_REG_RD            [i]))
		      << (*(in_READ_UNIT_OUT_WRITE_RE              [i]))
		      << (*(in_READ_UNIT_OUT_NUM_REG_RE            [i]));

	    if (_param->_have_port_context_id)
	    sensitive  << (*(in_READ_UNIT_OUT_CONTEXT_ID            [i]));
	    if (_param->_have_port_front_end_id)
	    sensitive  << (*(in_READ_UNIT_OUT_FRONT_END_ID          [i]));
	    if (_param->_have_port_ooo_engine_id)
	    sensitive  << (*(in_READ_UNIT_OUT_OOO_ENGINE_ID         [i]));
	    if (_param->_have_port_packet_id)
	    sensitive  << (*(in_READ_UNIT_OUT_PACKET_ID             [i]));
	  }
	
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  sensitive << (*(in_EXECUTE_UNIT_IN_ACK                 [i]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_read_unit; i++)
	  {
	    (*(out_READ_UNIT_OUT_ACK [i])) (*(in_READ_UNIT_OUT_VAL           [i]));
	    (*(out_READ_UNIT_OUT_ACK [i])) (*(in_READ_UNIT_OUT_TYPE          [i]));
	    if (_param->_have_port_context_id)
	    (*(out_READ_UNIT_OUT_ACK [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [i]));
	    if (_param->_have_port_front_end_id)
	    (*(out_READ_UNIT_OUT_ACK [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [i]));
	    if (_param->_have_port_ooo_engine_id)
	    (*(out_READ_UNIT_OUT_ACK [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [i]));

	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      (*(out_READ_UNIT_OUT_ACK [i])) (*(in_EXECUTE_UNIT_IN_ACK [j]));
	  }

	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  {
	    (*(out_EXECUTE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_VAL [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_VAL [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_VAL [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_VAL [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_VAL [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    if (_param->_have_port_context_id)
	      {
	    (*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	      }

	    if (_param->_have_port_front_end_id)
	      {
	    (*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	      }

	    if (_param->_have_port_ooo_engine_id)
	      {
	    (*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	      }

	    if (_param->_have_port_packet_id)
	      {
	    (*(out_EXECUTE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i])) (*(in_READ_UNIT_OUT_PACKET_ID     [j]));
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	      }

	    (*(out_EXECUTE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_OPERATION [i])) (*(in_READ_UNIT_OUT_OPERATION     [j]));
		(*(out_EXECUTE_UNIT_IN_OPERATION [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_OPERATION [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_OPERATION [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_OPERATION [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_OPERATION [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_TYPE [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_TYPE [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_TYPE [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_TYPE [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_TYPE [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE [j]));
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_VAL                   [j]));
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_TYPE                  [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID            [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID          [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE [j]));
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_VAL                  [j]));
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_TYPE                 [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID           [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID         [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID        [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_HAS_IMMEDIAT  [j]));
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_IMMEDIAT [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_IMMEDIAT      [j]));
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_DATA_RA [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i])) (*(in_READ_UNIT_OUT_DATA_RA       [j]));
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_DATA_RB [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i])) (*(in_READ_UNIT_OUT_DATA_RB       [j]));
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_DATA_RC [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i])) (*(in_READ_UNIT_OUT_DATA_RC       [j]));
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i])) (*(in_READ_UNIT_OUT_WRITE_RD      [j]));
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i])) (*(in_READ_UNIT_OUT_NUM_REG_RD    [j]));
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i])) (*(in_READ_UNIT_OUT_WRITE_RE      [j]));
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_IN_ACK [i]));

	    for (uint32_t j=0; j<_param->_nb_read_unit; j++)
	      {
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i])) (*(in_READ_UNIT_OUT_NUM_REG_RE    [j]));
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i])) (*(in_READ_UNIT_OUT_VAL           [j]));
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i])) (*(in_READ_UNIT_OUT_TYPE          [j]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	  }
# endif    
	
#endif
      }
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::~Read_unit_to_Execution_unit"
  Read_unit_to_Execution_unit::~Read_unit_to_Execution_unit (void)
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
